<?php
declare(strict_types=1);

/**
 * EnvelopesApi.
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Api\EnvelopesApi;


/**
 * ApplyTemplateOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ApplyTemplateOptions
{
    /**
      * $preserve_template_recipient 
      * @var ?string
      */
    protected ?string $preserve_template_recipient = null;

    /**
     * Gets preserve_template_recipient
     *
     * @return ?string
     */
    public function getPreserveTemplateRecipient(): ?string
    {
        return $this->preserve_template_recipient;
    }

    /**
     * Sets preserve_template_recipient
     * @param ?string $preserve_template_recipient 
     *
     * @return self
     */
    public function setPreserveTemplateRecipient(?string $preserve_template_recipient): self
    {
        $this->preserve_template_recipient = $preserve_template_recipient;
        return $this;
    }
}


/**
 * ApplyTemplateToDocumentOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ApplyTemplateToDocumentOptions
{
    /**
      * $preserve_template_recipient 
      * @var ?string
      */
    protected ?string $preserve_template_recipient = null;

    /**
     * Gets preserve_template_recipient
     *
     * @return ?string
     */
    public function getPreserveTemplateRecipient(): ?string
    {
        return $this->preserve_template_recipient;
    }

    /**
     * Sets preserve_template_recipient
     * @param ?string $preserve_template_recipient 
     *
     * @return self
     */
    public function setPreserveTemplateRecipient(?string $preserve_template_recipient): self
    {
        $this->preserve_template_recipient = $preserve_template_recipient;
        return $this;
    }
}


/**
 * CreateEnvelopeOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CreateEnvelopeOptions
{
    /**
      * $cdse_mode 
      * @var ?string
      */
    protected ?string $cdse_mode = null;

    /**
     * Gets cdse_mode
     *
     * @return ?string
     */
    public function getCdseMode(): ?string
    {
        return $this->cdse_mode;
    }

    /**
     * Sets cdse_mode
     * @param ?string $cdse_mode 
     *
     * @return self
     */
    public function setCdseMode(?string $cdse_mode): self
    {
        $this->cdse_mode = $cdse_mode;
        return $this;
    }
    /**
      * $change_routing_order 
      * @var ?string
      */
    protected ?string $change_routing_order = null;

    /**
     * Gets change_routing_order
     *
     * @return ?string
     */
    public function getChangeRoutingOrder(): ?string
    {
        return $this->change_routing_order;
    }

    /**
     * Sets change_routing_order
     * @param ?string $change_routing_order 
     *
     * @return self
     */
    public function setChangeRoutingOrder(?string $change_routing_order): self
    {
        $this->change_routing_order = $change_routing_order;
        return $this;
    }
    /**
      * $completed_documents_only If set to true then we want to set the sourceEnvelopeId to indicate that this is a\"forward\" envelope action
      * @var ?string
      */
    protected ?string $completed_documents_only = null;

    /**
     * Gets completed_documents_only
     *
     * @return ?string
     */
    public function getCompletedDocumentsOnly(): ?string
    {
        return $this->completed_documents_only;
    }

    /**
     * Sets completed_documents_only
     * @param ?string $completed_documents_only If set to true then we want to set the sourceEnvelopeId to indicate that this is a\"forward\" envelope action
     *
     * @return self
     */
    public function setCompletedDocumentsOnly(?string $completed_documents_only): self
    {
        $this->completed_documents_only = $completed_documents_only;
        return $this;
    }
    /**
      * $merge_roles_on_draft When set to **true**, merges template roles and remove empty recipients when you create an envelope with multiple templates.
      * @var ?string
      */
    protected ?string $merge_roles_on_draft = null;

    /**
     * Gets merge_roles_on_draft
     *
     * @return ?string
     */
    public function getMergeRolesOnDraft(): ?string
    {
        return $this->merge_roles_on_draft;
    }

    /**
     * Sets merge_roles_on_draft
     * @param ?string $merge_roles_on_draft When set to **true**, merges template roles and remove empty recipients when you create an envelope with multiple templates.
     *
     * @return self
     */
    public function setMergeRolesOnDraft(?string $merge_roles_on_draft): self
    {
        $this->merge_roles_on_draft = $merge_roles_on_draft;
        return $this;
    }
    /**
      * $tab_label_exact_matches 
      * @var ?string
      */
    protected ?string $tab_label_exact_matches = null;

    /**
     * Gets tab_label_exact_matches
     *
     * @return ?string
     */
    public function getTabLabelExactMatches(): ?string
    {
        return $this->tab_label_exact_matches;
    }

    /**
     * Sets tab_label_exact_matches
     * @param ?string $tab_label_exact_matches 
     *
     * @return self
     */
    public function setTabLabelExactMatches(?string $tab_label_exact_matches): self
    {
        $this->tab_label_exact_matches = $tab_label_exact_matches;
        return $this;
    }
}


/**
 * CreateRecipientOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class CreateRecipientOptions
{
    /**
      * $resend_envelope When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope's next recipient.
      * @var ?string
      */
    protected ?string $resend_envelope = null;

    /**
     * Gets resend_envelope
     *
     * @return ?string
     */
    public function getResendEnvelope(): ?string
    {
        return $this->resend_envelope;
    }

    /**
     * Sets resend_envelope
     * @param ?string $resend_envelope When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope's next recipient.
     *
     * @return self
     */
    public function setResendEnvelope(?string $resend_envelope): self
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}


/**
 * GetChunkedUploadOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetChunkedUploadOptions
{
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
}


/**
 * GetCommentsTranscriptOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetCommentsTranscriptOptions
{
    /**
      * $encoding 
      * @var ?string
      */
    protected ?string $encoding = null;

    /**
     * Gets encoding
     *
     * @return ?string
     */
    public function getEncoding(): ?string
    {
        return $this->encoding;
    }

    /**
     * Sets encoding
     * @param ?string $encoding 
     *
     * @return self
     */
    public function setEncoding(?string $encoding): self
    {
        $this->encoding = $encoding;
        return $this;
    }
}


/**
 * GetConsumerDisclosureOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetConsumerDisclosureOptions
{
    /**
      * $lang_code2 The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to ï¿½browserï¿½ to automatically detect the browser language being used by the viewer and display the disclosure in that language.
      * @var ?string
      */
    protected ?string $lang_code2 = null;

    /**
     * Gets lang_code2
     *
     * @return ?string
     */
    public function getLangCode2(): ?string
    {
        return $this->lang_code2;
    }

    /**
     * Sets lang_code2
     * @param ?string $lang_code2 The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to ï¿½browserï¿½ to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     *
     * @return self
     */
    public function setLangCode2(?string $lang_code2): self
    {
        $this->lang_code2 = $lang_code2;
        return $this;
    }
}


/**
 * GetConsumerDisclosureDefaultOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetConsumerDisclosureDefaultOptions
{
    /**
      * $lang_code 
      * @var ?string
      */
    protected ?string $lang_code = null;

    /**
     * Gets lang_code
     *
     * @return ?string
     */
    public function getLangCode(): ?string
    {
        return $this->lang_code;
    }

    /**
     * Sets lang_code
     * @param ?string $lang_code 
     *
     * @return self
     */
    public function setLangCode(?string $lang_code): self
    {
        $this->lang_code = $lang_code;
        return $this;
    }
}


/**
 * GetDocumentOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetDocumentOptions
{
    /**
      * $certificate When set to **false**, the envelope signing certificate is removed from the download.
      * @var ?string
      */
    protected ?string $certificate = null;

    /**
     * Gets certificate
     *
     * @return ?string
     */
    public function getCertificate(): ?string
    {
        return $this->certificate;
    }

    /**
     * Sets certificate
     * @param ?string $certificate When set to **false**, the envelope signing certificate is removed from the download.
     *
     * @return self
     */
    public function setCertificate(?string $certificate): self
    {
        $this->certificate = $certificate;
        return $this;
    }
    /**
      * $documents_by_userid 
      * @var ?string
      */
    protected ?string $documents_by_userid = null;

    /**
     * Gets documents_by_userid
     *
     * @return ?string
     */
    public function getDocumentsByUserid(): ?string
    {
        return $this->documents_by_userid;
    }

    /**
     * Sets documents_by_userid
     * @param ?string $documents_by_userid 
     *
     * @return self
     */
    public function setDocumentsByUserid(?string $documents_by_userid): self
    {
        $this->documents_by_userid = $documents_by_userid;
        return $this;
    }
    /**
      * $encoding 
      * @var ?string
      */
    protected ?string $encoding = null;

    /**
     * Gets encoding
     *
     * @return ?string
     */
    public function getEncoding(): ?string
    {
        return $this->encoding;
    }

    /**
     * Sets encoding
     * @param ?string $encoding 
     *
     * @return self
     */
    public function setEncoding(?string $encoding): self
    {
        $this->encoding = $encoding;
        return $this;
    }
    /**
      * $encrypt When set to **true**, the PDF bytes returned in the response are encrypted for all the key managers configured on your DocuSign account. The documents can be decrypted with the KeyManager Decrypt Document API.
      * @var ?string
      */
    protected ?string $encrypt = null;

    /**
     * Gets encrypt
     *
     * @return ?string
     */
    public function getEncrypt(): ?string
    {
        return $this->encrypt;
    }

    /**
     * Sets encrypt
     * @param ?string $encrypt When set to **true**, the PDF bytes returned in the response are encrypted for all the key managers configured on your DocuSign account. The documents can be decrypted with the KeyManager Decrypt Document API.
     *
     * @return self
     */
    public function setEncrypt(?string $encrypt): self
    {
        $this->encrypt = $encrypt;
        return $this;
    }
    /**
      * $language Specifies the language for the Certificate of Completion in the response. The supported languages, with the language value shown in parenthesis, are: Chinese Simplified (zh_CN), , Chinese Traditional (zh_TW), Dutch (nl), English US (en), French (fr), German (de), Italian (it), Japanese (ja), Korean (ko), Portuguese (pt), Portuguese (Brazil) (pt_BR), Russian (ru), Spanish (es).
      * @var ?string
      */
    protected ?string $language = null;

    /**
     * Gets language
     *
     * @return ?string
     */
    public function getLanguage(): ?string
    {
        return $this->language;
    }

    /**
     * Sets language
     * @param ?string $language Specifies the language for the Certificate of Completion in the response. The supported languages, with the language value shown in parenthesis, are: Chinese Simplified (zh_CN), , Chinese Traditional (zh_TW), Dutch (nl), English US (en), French (fr), German (de), Italian (it), Japanese (ja), Korean (ko), Portuguese (pt), Portuguese (Brazil) (pt_BR), Russian (ru), Spanish (es).
     *
     * @return self
     */
    public function setLanguage(?string $language): self
    {
        $this->language = $language;
        return $this;
    }
    /**
      * $recipient_id 
      * @var ?string
      */
    protected ?string $recipient_id = null;

    /**
     * Gets recipient_id
     *
     * @return ?string
     */
    public function getRecipientId(): ?string
    {
        return $this->recipient_id;
    }

    /**
     * Sets recipient_id
     * @param ?string $recipient_id 
     *
     * @return self
     */
    public function setRecipientId(?string $recipient_id): self
    {
        $this->recipient_id = $recipient_id;
        return $this;
    }
    /**
      * $shared_user_id 
      * @var ?string
      */
    protected ?string $shared_user_id = null;

    /**
     * Gets shared_user_id
     *
     * @return ?string
     */
    public function getSharedUserId(): ?string
    {
        return $this->shared_user_id;
    }

    /**
     * Sets shared_user_id
     * @param ?string $shared_user_id 
     *
     * @return self
     */
    public function setSharedUserId(?string $shared_user_id): self
    {
        $this->shared_user_id = $shared_user_id;
        return $this;
    }
    /**
      * $show_changes When set to **true**, any changed fields for the returned PDF are highlighted in yellow and optional signatures or initials outlined in red.
      * @var ?string
      */
    protected ?string $show_changes = null;

    /**
     * Gets show_changes
     *
     * @return ?string
     */
    public function getShowChanges(): ?string
    {
        return $this->show_changes;
    }

    /**
     * Sets show_changes
     * @param ?string $show_changes When set to **true**, any changed fields for the returned PDF are highlighted in yellow and optional signatures or initials outlined in red.
     *
     * @return self
     */
    public function setShowChanges(?string $show_changes): self
    {
        $this->show_changes = $show_changes;
        return $this;
    }
    /**
      * $watermark When set to **true**, the account has the watermark feature enabled, and the envelope is not complete, the watermark for the account is added to the PDF documents. This option can remove the watermark.
      * @var ?string
      */
    protected ?string $watermark = null;

    /**
     * Gets watermark
     *
     * @return ?string
     */
    public function getWatermark(): ?string
    {
        return $this->watermark;
    }

    /**
     * Sets watermark
     * @param ?string $watermark When set to **true**, the account has the watermark feature enabled, and the envelope is not complete, the watermark for the account is added to the PDF documents. This option can remove the watermark.
     *
     * @return self
     */
    public function setWatermark(?string $watermark): self
    {
        $this->watermark = $watermark;
        return $this;
    }
}


/**
 * GetDocumentPageImageOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetDocumentPageImageOptions
{
    /**
      * $dpi Sets the dpi for the image.
      * @var ?string
      */
    protected ?string $dpi = null;

    /**
     * Gets dpi
     *
     * @return ?string
     */
    public function getDpi(): ?string
    {
        return $this->dpi;
    }

    /**
     * Sets dpi
     * @param ?string $dpi Sets the dpi for the image.
     *
     * @return self
     */
    public function setDpi(?string $dpi): self
    {
        $this->dpi = $dpi;
        return $this;
    }
    /**
      * $max_height Sets the maximum height for the page image in pixels. The dpi is recalculated based on this setting.
      * @var ?string
      */
    protected ?string $max_height = null;

    /**
     * Gets max_height
     *
     * @return ?string
     */
    public function getMaxHeight(): ?string
    {
        return $this->max_height;
    }

    /**
     * Sets max_height
     * @param ?string $max_height Sets the maximum height for the page image in pixels. The dpi is recalculated based on this setting.
     *
     * @return self
     */
    public function setMaxHeight(?string $max_height): self
    {
        $this->max_height = $max_height;
        return $this;
    }
    /**
      * $max_width Sets the maximum width for the page image in pixels. The dpi is recalculated based on this setting.
      * @var ?string
      */
    protected ?string $max_width = null;

    /**
     * Gets max_width
     *
     * @return ?string
     */
    public function getMaxWidth(): ?string
    {
        return $this->max_width;
    }

    /**
     * Sets max_width
     * @param ?string $max_width Sets the maximum width for the page image in pixels. The dpi is recalculated based on this setting.
     *
     * @return self
     */
    public function setMaxWidth(?string $max_width): self
    {
        $this->max_width = $max_width;
        return $this;
    }
    /**
      * $show_changes 
      * @var ?string
      */
    protected ?string $show_changes = null;

    /**
     * Gets show_changes
     *
     * @return ?string
     */
    public function getShowChanges(): ?string
    {
        return $this->show_changes;
    }

    /**
     * Sets show_changes
     * @param ?string $show_changes 
     *
     * @return self
     */
    public function setShowChanges(?string $show_changes): self
    {
        $this->show_changes = $show_changes;
        return $this;
    }
}


/**
 * GetDocumentTabsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetDocumentTabsOptions
{
    /**
      * $include_metadata 
      * @var ?string
      */
    protected ?string $include_metadata = null;

    /**
     * Gets include_metadata
     *
     * @return ?string
     */
    public function getIncludeMetadata(): ?string
    {
        return $this->include_metadata;
    }

    /**
     * Sets include_metadata
     * @param ?string $include_metadata 
     *
     * @return self
     */
    public function setIncludeMetadata(?string $include_metadata): self
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
    /**
      * $page_numbers 
      * @var ?string
      */
    protected ?string $page_numbers = null;

    /**
     * Gets page_numbers
     *
     * @return ?string
     */
    public function getPageNumbers(): ?string
    {
        return $this->page_numbers;
    }

    /**
     * Sets page_numbers
     * @param ?string $page_numbers 
     *
     * @return self
     */
    public function setPageNumbers(?string $page_numbers): self
    {
        $this->page_numbers = $page_numbers;
        return $this;
    }
}


/**
 * GetEnvelopeOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetEnvelopeOptions
{
    /**
      * $advanced_update When true, envelope information can be added or modified.
      * @var ?string
      */
    protected ?string $advanced_update = null;

    /**
     * Gets advanced_update
     *
     * @return ?string
     */
    public function getAdvancedUpdate(): ?string
    {
        return $this->advanced_update;
    }

    /**
     * Sets advanced_update
     * @param ?string $advanced_update When true, envelope information can be added or modified.
     *
     * @return self
     */
    public function setAdvancedUpdate(?string $advanced_update): self
    {
        $this->advanced_update = $advanced_update;
        return $this;
    }
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
}


/**
 * GetEnvelopeTransferRulesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetEnvelopeTransferRulesOptions
{
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
}


/**
 * GetPagesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetPagesOptions
{
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $dpi 
      * @var ?string
      */
    protected ?string $dpi = null;

    /**
     * Gets dpi
     *
     * @return ?string
     */
    public function getDpi(): ?string
    {
        return $this->dpi;
    }

    /**
     * Sets dpi
     * @param ?string $dpi 
     *
     * @return self
     */
    public function setDpi(?string $dpi): self
    {
        $this->dpi = $dpi;
        return $this;
    }
    /**
      * $max_height 
      * @var ?string
      */
    protected ?string $max_height = null;

    /**
     * Gets max_height
     *
     * @return ?string
     */
    public function getMaxHeight(): ?string
    {
        return $this->max_height;
    }

    /**
     * Sets max_height
     * @param ?string $max_height 
     *
     * @return self
     */
    public function setMaxHeight(?string $max_height): self
    {
        $this->max_height = $max_height;
        return $this;
    }
    /**
      * $max_width 
      * @var ?string
      */
    protected ?string $max_width = null;

    /**
     * Gets max_width
     *
     * @return ?string
     */
    public function getMaxWidth(): ?string
    {
        return $this->max_width;
    }

    /**
     * Sets max_width
     * @param ?string $max_width 
     *
     * @return self
     */
    public function setMaxWidth(?string $max_width): self
    {
        $this->max_width = $max_width;
        return $this;
    }
    /**
      * $nocache 
      * @var ?string
      */
    protected ?string $nocache = null;

    /**
     * Gets nocache
     *
     * @return ?string
     */
    public function getNocache(): ?string
    {
        return $this->nocache;
    }

    /**
     * Sets nocache
     * @param ?string $nocache 
     *
     * @return self
     */
    public function setNocache(?string $nocache): self
    {
        $this->nocache = $nocache;
        return $this;
    }
    /**
      * $show_changes 
      * @var ?string
      */
    protected ?string $show_changes = null;

    /**
     * Gets show_changes
     *
     * @return ?string
     */
    public function getShowChanges(): ?string
    {
        return $this->show_changes;
    }

    /**
     * Sets show_changes
     * @param ?string $show_changes 
     *
     * @return self
     */
    public function setShowChanges(?string $show_changes): self
    {
        $this->show_changes = $show_changes;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
}


/**
 * GetRecipientInitialsImageOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetRecipientInitialsImageOptions
{
    /**
      * $include_chrome The added line and identifier around the initial image. Note: Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.
      * @var ?string
      */
    protected ?string $include_chrome = null;

    /**
     * Gets include_chrome
     *
     * @return ?string
     */
    public function getIncludeChrome(): ?string
    {
        return $this->include_chrome;
    }

    /**
     * Sets include_chrome
     * @param ?string $include_chrome The added line and identifier around the initial image. Note: Older envelopes might only have chromed images. If getting the non-chromed image fails, try getting the chromed image.
     *
     * @return self
     */
    public function setIncludeChrome(?string $include_chrome): self
    {
        $this->include_chrome = $include_chrome;
        return $this;
    }
}


/**
 * GetRecipientSignatureImageOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class GetRecipientSignatureImageOptions
{
    /**
      * $include_chrome When set to **true**, indicates the chromed version of the signature image should be retrieved.
      * @var ?string
      */
    protected ?string $include_chrome = null;

    /**
     * Gets include_chrome
     *
     * @return ?string
     */
    public function getIncludeChrome(): ?string
    {
        return $this->include_chrome;
    }

    /**
     * Sets include_chrome
     * @param ?string $include_chrome When set to **true**, indicates the chromed version of the signature image should be retrieved.
     *
     * @return self
     */
    public function setIncludeChrome(?string $include_chrome): self
    {
        $this->include_chrome = $include_chrome;
        return $this;
    }
}


/**
 * ListDocumentsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListDocumentsOptions
{
    /**
      * $documents_by_userid 
      * @var ?string
      */
    protected ?string $documents_by_userid = null;

    /**
     * Gets documents_by_userid
     *
     * @return ?string
     */
    public function getDocumentsByUserid(): ?string
    {
        return $this->documents_by_userid;
    }

    /**
     * Sets documents_by_userid
     * @param ?string $documents_by_userid 
     *
     * @return self
     */
    public function setDocumentsByUserid(?string $documents_by_userid): self
    {
        $this->documents_by_userid = $documents_by_userid;
        return $this;
    }
    /**
      * $include_docgen_formfields 
      * @var ?string
      */
    protected ?string $include_docgen_formfields = null;

    /**
     * Gets include_docgen_formfields
     *
     * @return ?string
     */
    public function getIncludeDocgenFormfields(): ?string
    {
        return $this->include_docgen_formfields;
    }

    /**
     * Sets include_docgen_formfields
     * @param ?string $include_docgen_formfields 
     *
     * @return self
     */
    public function setIncludeDocgenFormfields(?string $include_docgen_formfields): self
    {
        $this->include_docgen_formfields = $include_docgen_formfields;
        return $this;
    }
    /**
      * $include_document_size 
      * @var ?string
      */
    protected ?string $include_document_size = null;

    /**
     * Gets include_document_size
     *
     * @return ?string
     */
    public function getIncludeDocumentSize(): ?string
    {
        return $this->include_document_size;
    }

    /**
     * Sets include_document_size
     * @param ?string $include_document_size 
     *
     * @return self
     */
    public function setIncludeDocumentSize(?string $include_document_size): self
    {
        $this->include_document_size = $include_document_size;
        return $this;
    }
    /**
      * $include_metadata 
      * @var ?string
      */
    protected ?string $include_metadata = null;

    /**
     * Gets include_metadata
     *
     * @return ?string
     */
    public function getIncludeMetadata(): ?string
    {
        return $this->include_metadata;
    }

    /**
     * Sets include_metadata
     * @param ?string $include_metadata 
     *
     * @return self
     */
    public function setIncludeMetadata(?string $include_metadata): self
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
    /**
      * $include_tabs 
      * @var ?string
      */
    protected ?string $include_tabs = null;

    /**
     * Gets include_tabs
     *
     * @return ?string
     */
    public function getIncludeTabs(): ?string
    {
        return $this->include_tabs;
    }

    /**
     * Sets include_tabs
     * @param ?string $include_tabs 
     *
     * @return self
     */
    public function setIncludeTabs(?string $include_tabs): self
    {
        $this->include_tabs = $include_tabs;
        return $this;
    }
    /**
      * $recipient_id 
      * @var ?string
      */
    protected ?string $recipient_id = null;

    /**
     * Gets recipient_id
     *
     * @return ?string
     */
    public function getRecipientId(): ?string
    {
        return $this->recipient_id;
    }

    /**
     * Sets recipient_id
     * @param ?string $recipient_id 
     *
     * @return self
     */
    public function setRecipientId(?string $recipient_id): self
    {
        $this->recipient_id = $recipient_id;
        return $this;
    }
    /**
      * $shared_user_id 
      * @var ?string
      */
    protected ?string $shared_user_id = null;

    /**
     * Gets shared_user_id
     *
     * @return ?string
     */
    public function getSharedUserId(): ?string
    {
        return $this->shared_user_id;
    }

    /**
     * Sets shared_user_id
     * @param ?string $shared_user_id 
     *
     * @return self
     */
    public function setSharedUserId(?string $shared_user_id): self
    {
        $this->shared_user_id = $shared_user_id;
        return $this;
    }
}


/**
 * ListRecipientsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListRecipientsOptions
{
    /**
      * $include_anchor_tab_locations When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response.
      * @var ?string
      */
    protected ?string $include_anchor_tab_locations = null;

    /**
     * Gets include_anchor_tab_locations
     *
     * @return ?string
     */
    public function getIncludeAnchorTabLocations(): ?string
    {
        return $this->include_anchor_tab_locations;
    }

    /**
     * Sets include_anchor_tab_locations
     * @param ?string $include_anchor_tab_locations When set to **true** and `include_tabs` is set to **true**, all tabs with anchor tab properties are included in the response.
     *
     * @return self
     */
    public function setIncludeAnchorTabLocations(?string $include_anchor_tab_locations): self
    {
        $this->include_anchor_tab_locations = $include_anchor_tab_locations;
        return $this;
    }
    /**
      * $include_extended When set to **true**, the extended properties are included in the response.
      * @var ?string
      */
    protected ?string $include_extended = null;

    /**
     * Gets include_extended
     *
     * @return ?string
     */
    public function getIncludeExtended(): ?string
    {
        return $this->include_extended;
    }

    /**
     * Sets include_extended
     * @param ?string $include_extended When set to **true**, the extended properties are included in the response.
     *
     * @return self
     */
    public function setIncludeExtended(?string $include_extended): self
    {
        $this->include_extended = $include_extended;
        return $this;
    }
    /**
      * $include_metadata 
      * @var ?string
      */
    protected ?string $include_metadata = null;

    /**
     * Gets include_metadata
     *
     * @return ?string
     */
    public function getIncludeMetadata(): ?string
    {
        return $this->include_metadata;
    }

    /**
     * Sets include_metadata
     * @param ?string $include_metadata 
     *
     * @return self
     */
    public function setIncludeMetadata(?string $include_metadata): self
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
    /**
      * $include_tabs When set to **true**, the tab information associated with the recipient is included in the response.
      * @var ?string
      */
    protected ?string $include_tabs = null;

    /**
     * Gets include_tabs
     *
     * @return ?string
     */
    public function getIncludeTabs(): ?string
    {
        return $this->include_tabs;
    }

    /**
     * Sets include_tabs
     * @param ?string $include_tabs When set to **true**, the tab information associated with the recipient is included in the response.
     *
     * @return self
     */
    public function setIncludeTabs(?string $include_tabs): self
    {
        $this->include_tabs = $include_tabs;
        return $this;
    }
}


/**
 * ListStatusOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListStatusOptions
{
    /**
      * $ac_status 
      * @var ?string
      */
    protected ?string $ac_status = null;

    /**
     * Gets ac_status
     *
     * @return ?string
     */
    public function getAcStatus(): ?string
    {
        return $this->ac_status;
    }

    /**
     * Sets ac_status
     * @param ?string $ac_status 
     *
     * @return self
     */
    public function setAcStatus(?string $ac_status): self
    {
        $this->ac_status = $ac_status;
        return $this;
    }
    /**
      * $block 
      * @var ?string
      */
    protected ?string $block = null;

    /**
     * Gets block
     *
     * @return ?string
     */
    public function getBlock(): ?string
    {
        return $this->block;
    }

    /**
     * Sets block
     * @param ?string $block 
     *
     * @return self
     */
    public function setBlock(?string $block): self
    {
        $this->block = $block;
        return $this;
    }
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $email 
      * @var ?string
      */
    protected ?string $email = null;

    /**
     * Gets email
     *
     * @return ?string
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * Sets email
     * @param ?string $email 
     *
     * @return self
     */
    public function setEmail(?string $email): self
    {
        $this->email = $email;
        return $this;
    }
    /**
      * $envelope_ids 
      * @var ?string
      */
    protected ?string $envelope_ids = null;

    /**
     * Gets envelope_ids
     *
     * @return ?string
     */
    public function getEnvelopeIds(): ?string
    {
        return $this->envelope_ids;
    }

    /**
     * Sets envelope_ids
     * @param ?string $envelope_ids 
     *
     * @return self
     */
    public function setEnvelopeIds(?string $envelope_ids): self
    {
        $this->envelope_ids = $envelope_ids;
        return $this;
    }
    /**
      * $from_date 
      * @var ?string
      */
    protected ?string $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate(): ?string
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * @param ?string $from_date 
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $from_to_status 
      * @var ?string
      */
    protected ?string $from_to_status = null;

    /**
     * Gets from_to_status
     *
     * @return ?string
     */
    public function getFromToStatus(): ?string
    {
        return $this->from_to_status;
    }

    /**
     * Sets from_to_status
     * @param ?string $from_to_status 
     *
     * @return self
     */
    public function setFromToStatus(?string $from_to_status): self
    {
        $this->from_to_status = $from_to_status;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $status 
      * @var ?string
      */
    protected ?string $status = null;

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets status
     * @param ?string $status 
     *
     * @return self
     */
    public function setStatus(?string $status): self
    {
        $this->status = $status;
        return $this;
    }
    /**
      * $to_date 
      * @var ?string
      */
    protected ?string $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate(): ?string
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * @param ?string $to_date 
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
    /**
      * $transaction_ids 
      * @var ?string
      */
    protected ?string $transaction_ids = null;

    /**
     * Gets transaction_ids
     *
     * @return ?string
     */
    public function getTransactionIds(): ?string
    {
        return $this->transaction_ids;
    }

    /**
     * Sets transaction_ids
     * @param ?string $transaction_ids 
     *
     * @return self
     */
    public function setTransactionIds(?string $transaction_ids): self
    {
        $this->transaction_ids = $transaction_ids;
        return $this;
    }
    /**
      * $user_name 
      * @var ?string
      */
    protected ?string $user_name = null;

    /**
     * Gets user_name
     *
     * @return ?string
     */
    public function getUserName(): ?string
    {
        return $this->user_name;
    }

    /**
     * Sets user_name
     * @param ?string $user_name 
     *
     * @return self
     */
    public function setUserName(?string $user_name): self
    {
        $this->user_name = $user_name;
        return $this;
    }
}


/**
 * ListStatusChangesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListStatusChangesOptions
{
    /**
      * $ac_status Specifies the Authoritative Copy Status for the envelopes. The possible values are: Unknown, Original, Transferred, AuthoritativeCopy, AuthoritativeCopyExportPending, AuthoritativeCopyExported, DepositPending, Deposited, DepositedEO, or DepositFailed.
      * @var ?string
      */
    protected ?string $ac_status = null;

    /**
     * Gets ac_status
     *
     * @return ?string
     */
    public function getAcStatus(): ?string
    {
        return $this->ac_status;
    }

    /**
     * Sets ac_status
     * @param ?string $ac_status Specifies the Authoritative Copy Status for the envelopes. The possible values are: Unknown, Original, Transferred, AuthoritativeCopy, AuthoritativeCopyExportPending, AuthoritativeCopyExported, DepositPending, Deposited, DepositedEO, or DepositFailed.
     *
     * @return self
     */
    public function setAcStatus(?string $ac_status): self
    {
        $this->ac_status = $ac_status;
        return $this;
    }
    /**
      * $block 
      * @var ?string
      */
    protected ?string $block = null;

    /**
     * Gets block
     *
     * @return ?string
     */
    public function getBlock(): ?string
    {
        return $this->block;
    }

    /**
     * Sets block
     * @param ?string $block 
     *
     * @return self
     */
    public function setBlock(?string $block): self
    {
        $this->block = $block;
        return $this;
    }
    /**
      * $cdse_mode 
      * @var ?string
      */
    protected ?string $cdse_mode = null;

    /**
     * Gets cdse_mode
     *
     * @return ?string
     */
    public function getCdseMode(): ?string
    {
        return $this->cdse_mode;
    }

    /**
     * Sets cdse_mode
     * @param ?string $cdse_mode 
     *
     * @return self
     */
    public function setCdseMode(?string $cdse_mode): self
    {
        $this->cdse_mode = $cdse_mode;
        return $this;
    }
    /**
      * $continuation_token 
      * @var ?string
      */
    protected ?string $continuation_token = null;

    /**
     * Gets continuation_token
     *
     * @return ?string
     */
    public function getContinuationToken(): ?string
    {
        return $this->continuation_token;
    }

    /**
     * Sets continuation_token
     * @param ?string $continuation_token 
     *
     * @return self
     */
    public function setContinuationToken(?string $continuation_token): self
    {
        $this->continuation_token = $continuation_token;
        return $this;
    }
    /**
      * $count 
      * @var ?string
      */
    protected ?string $count = null;

    /**
     * Gets count
     *
     * @return ?string
     */
    public function getCount(): ?string
    {
        return $this->count;
    }

    /**
     * Sets count
     * @param ?string $count 
     *
     * @return self
     */
    public function setCount(?string $count): self
    {
        $this->count = $count;
        return $this;
    }
    /**
      * $custom_field This specifies the envelope custom field name and value searched for in the envelope information. The value portion of the query can use partial strings by adding '%' (percent sign) around the custom field query value.   Example 1: If you have an envelope custom field called \"Region\" and you want to search for all envelopes where the value is \"West\" you would use the query: `?custom_field=Region=West`.   Example 2: To search for envelopes where the `ApplicationID` custom field has the value or partial value of \"DocuSign\" in field, the query would be: `?custom_field=ApplicationId=%DocuSign%` This would find envelopes where the custom field value is \"DocuSign for Salesforce\" or \"DocuSign envelope.\"
      * @var ?string
      */
    protected ?string $custom_field = null;

    /**
     * Gets custom_field
     *
     * @return ?string
     */
    public function getCustomField(): ?string
    {
        return $this->custom_field;
    }

    /**
     * Sets custom_field
     * @param ?string $custom_field This specifies the envelope custom field name and value searched for in the envelope information. The value portion of the query can use partial strings by adding '%' (percent sign) around the custom field query value.   Example 1: If you have an envelope custom field called \"Region\" and you want to search for all envelopes where the value is \"West\" you would use the query: `?custom_field=Region=West`.   Example 2: To search for envelopes where the `ApplicationID` custom field has the value or partial value of \"DocuSign\" in field, the query would be: `?custom_field=ApplicationId=%DocuSign%` This would find envelopes where the custom field value is \"DocuSign for Salesforce\" or \"DocuSign envelope.\"
     *
     * @return self
     */
    public function setCustomField(?string $custom_field): self
    {
        $this->custom_field = $custom_field;
        return $this;
    }
    /**
      * $email 
      * @var ?string
      */
    protected ?string $email = null;

    /**
     * Gets email
     *
     * @return ?string
     */
    public function getEmail(): ?string
    {
        return $this->email;
    }

    /**
     * Sets email
     * @param ?string $email 
     *
     * @return self
     */
    public function setEmail(?string $email): self
    {
        $this->email = $email;
        return $this;
    }
    /**
      * $envelope_ids 
      * @var ?string
      */
    protected ?string $envelope_ids = null;

    /**
     * Gets envelope_ids
     *
     * @return ?string
     */
    public function getEnvelopeIds(): ?string
    {
        return $this->envelope_ids;
    }

    /**
     * Sets envelope_ids
     * @param ?string $envelope_ids 
     *
     * @return self
     */
    public function setEnvelopeIds(?string $envelope_ids): self
    {
        $this->envelope_ids = $envelope_ids;
        return $this;
    }
    /**
      * $exclude 
      * @var ?string
      */
    protected ?string $exclude = null;

    /**
     * Gets exclude
     *
     * @return ?string
     */
    public function getExclude(): ?string
    {
        return $this->exclude;
    }

    /**
     * Sets exclude
     * @param ?string $exclude 
     *
     * @return self
     */
    public function setExclude(?string $exclude): self
    {
        $this->exclude = $exclude;
        return $this;
    }
    /**
      * $folder_ids 
      * @var ?string
      */
    protected ?string $folder_ids = null;

    /**
     * Gets folder_ids
     *
     * @return ?string
     */
    public function getFolderIds(): ?string
    {
        return $this->folder_ids;
    }

    /**
     * Sets folder_ids
     * @param ?string $folder_ids 
     *
     * @return self
     */
    public function setFolderIds(?string $folder_ids): self
    {
        $this->folder_ids = $folder_ids;
        return $this;
    }
    /**
      * $folder_types 
      * @var ?string
      */
    protected ?string $folder_types = null;

    /**
     * Gets folder_types
     *
     * @return ?string
     */
    public function getFolderTypes(): ?string
    {
        return $this->folder_types;
    }

    /**
     * Sets folder_types
     * @param ?string $folder_types 
     *
     * @return self
     */
    public function setFolderTypes(?string $folder_types): self
    {
        $this->folder_types = $folder_types;
        return $this;
    }
    /**
      * $from_date The date/time setting that specifies the date/time when the request begins checking for status changes for envelopes in the account.  This is required unless 'envelopeId's are used.
      * @var ?string
      */
    protected ?string $from_date = null;

    /**
     * Gets from_date
     *
     * @return ?string
     */
    public function getFromDate(): ?string
    {
        return $this->from_date;
    }

    /**
     * Sets from_date
     * @param ?string $from_date The date/time setting that specifies the date/time when the request begins checking for status changes for envelopes in the account.  This is required unless 'envelopeId's are used.
     *
     * @return self
     */
    public function setFromDate(?string $from_date): self
    {
        $this->from_date = $from_date;
        return $this;
    }
    /**
      * $from_to_status This is the status type checked for in the `from_date`/`to_date` period. If `changed` is specified, then envelopes that changed status during the period are found. If for example, `created` is specified, then envelopes created during the period are found. Default is `changed`.   Possible values are: Voided, Changed, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
      * @var ?string
      */
    protected ?string $from_to_status = null;

    /**
     * Gets from_to_status
     *
     * @return ?string
     */
    public function getFromToStatus(): ?string
    {
        return $this->from_to_status;
    }

    /**
     * Sets from_to_status
     * @param ?string $from_to_status This is the status type checked for in the `from_date`/`to_date` period. If `changed` is specified, then envelopes that changed status during the period are found. If for example, `created` is specified, then envelopes created during the period are found. Default is `changed`.   Possible values are: Voided, Changed, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
     *
     * @return self
     */
    public function setFromToStatus(?string $from_to_status): self
    {
        $this->from_to_status = $from_to_status;
        return $this;
    }
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
    /**
      * $include_purge_information 
      * @var ?string
      */
    protected ?string $include_purge_information = null;

    /**
     * Gets include_purge_information
     *
     * @return ?string
     */
    public function getIncludePurgeInformation(): ?string
    {
        return $this->include_purge_information;
    }

    /**
     * Sets include_purge_information
     * @param ?string $include_purge_information 
     *
     * @return self
     */
    public function setIncludePurgeInformation(?string $include_purge_information): self
    {
        $this->include_purge_information = $include_purge_information;
        return $this;
    }
    /**
      * $intersecting_folder_ids 
      * @var ?string
      */
    protected ?string $intersecting_folder_ids = null;

    /**
     * Gets intersecting_folder_ids
     *
     * @return ?string
     */
    public function getIntersectingFolderIds(): ?string
    {
        return $this->intersecting_folder_ids;
    }

    /**
     * Sets intersecting_folder_ids
     * @param ?string $intersecting_folder_ids 
     *
     * @return self
     */
    public function setIntersectingFolderIds(?string $intersecting_folder_ids): self
    {
        $this->intersecting_folder_ids = $intersecting_folder_ids;
        return $this;
    }
    /**
      * $last_queried_date 
      * @var ?string
      */
    protected ?string $last_queried_date = null;

    /**
     * Gets last_queried_date
     *
     * @return ?string
     */
    public function getLastQueriedDate(): ?string
    {
        return $this->last_queried_date;
    }

    /**
     * Sets last_queried_date
     * @param ?string $last_queried_date 
     *
     * @return self
     */
    public function setLastQueriedDate(?string $last_queried_date): self
    {
        $this->last_queried_date = $last_queried_date;
        return $this;
    }
    /**
      * $order 
      * @var ?string
      */
    protected ?string $order = null;

    /**
     * Gets order
     *
     * @return ?string
     */
    public function getOrder(): ?string
    {
        return $this->order;
    }

    /**
     * Sets order
     * @param ?string $order 
     *
     * @return self
     */
    public function setOrder(?string $order): self
    {
        $this->order = $order;
        return $this;
    }
    /**
      * $order_by 
      * @var ?string
      */
    protected ?string $order_by = null;

    /**
     * Gets order_by
     *
     * @return ?string
     */
    public function getOrderBy(): ?string
    {
        return $this->order_by;
    }

    /**
     * Sets order_by
     * @param ?string $order_by 
     *
     * @return self
     */
    public function setOrderBy(?string $order_by): self
    {
        $this->order_by = $order_by;
        return $this;
    }
    /**
      * $powerformids 
      * @var ?string
      */
    protected ?string $powerformids = null;

    /**
     * Gets powerformids
     *
     * @return ?string
     */
    public function getPowerformids(): ?string
    {
        return $this->powerformids;
    }

    /**
     * Sets powerformids
     * @param ?string $powerformids 
     *
     * @return self
     */
    public function setPowerformids(?string $powerformids): self
    {
        $this->powerformids = $powerformids;
        return $this;
    }
    /**
      * $query_budget 
      * @var ?string
      */
    protected ?string $query_budget = null;

    /**
     * Gets query_budget
     *
     * @return ?string
     */
    public function getQueryBudget(): ?string
    {
        return $this->query_budget;
    }

    /**
     * Sets query_budget
     * @param ?string $query_budget 
     *
     * @return self
     */
    public function setQueryBudget(?string $query_budget): self
    {
        $this->query_budget = $query_budget;
        return $this;
    }
    /**
      * $requester_date_format 
      * @var ?string
      */
    protected ?string $requester_date_format = null;

    /**
     * Gets requester_date_format
     *
     * @return ?string
     */
    public function getRequesterDateFormat(): ?string
    {
        return $this->requester_date_format;
    }

    /**
     * Sets requester_date_format
     * @param ?string $requester_date_format 
     *
     * @return self
     */
    public function setRequesterDateFormat(?string $requester_date_format): self
    {
        $this->requester_date_format = $requester_date_format;
        return $this;
    }
    /**
      * $search_mode 
      * @var ?string
      */
    protected ?string $search_mode = null;

    /**
     * Gets search_mode
     *
     * @return ?string
     */
    public function getSearchMode(): ?string
    {
        return $this->search_mode;
    }

    /**
     * Sets search_mode
     * @param ?string $search_mode 
     *
     * @return self
     */
    public function setSearchMode(?string $search_mode): self
    {
        $this->search_mode = $search_mode;
        return $this;
    }
    /**
      * $search_text 
      * @var ?string
      */
    protected ?string $search_text = null;

    /**
     * Gets search_text
     *
     * @return ?string
     */
    public function getSearchText(): ?string
    {
        return $this->search_text;
    }

    /**
     * Sets search_text
     * @param ?string $search_text 
     *
     * @return self
     */
    public function setSearchText(?string $search_text): self
    {
        $this->search_text = $search_text;
        return $this;
    }
    /**
      * $start_position 
      * @var ?string
      */
    protected ?string $start_position = null;

    /**
     * Gets start_position
     *
     * @return ?string
     */
    public function getStartPosition(): ?string
    {
        return $this->start_position;
    }

    /**
     * Sets start_position
     * @param ?string $start_position 
     *
     * @return self
     */
    public function setStartPosition(?string $start_position): self
    {
        $this->start_position = $start_position;
        return $this;
    }
    /**
      * $status The list of current statuses to include in the response. By default, all envelopes found are returned. If values are specified, then of the envelopes found, only those with the current status specified are returned in the results.   Possible values are: Voided, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
      * @var ?string
      */
    protected ?string $status = null;

    /**
     * Gets status
     *
     * @return ?string
     */
    public function getStatus(): ?string
    {
        return $this->status;
    }

    /**
     * Sets status
     * @param ?string $status The list of current statuses to include in the response. By default, all envelopes found are returned. If values are specified, then of the envelopes found, only those with the current status specified are returned in the results.   Possible values are: Voided, Created, Deleted, Sent, Delivered, Signed, Completed, Declined, TimedOut and Processing.
     *
     * @return self
     */
    public function setStatus(?string $status): self
    {
        $this->status = $status;
        return $this;
    }
    /**
      * $to_date Optional date/time setting that specifies the date/time when the request stops for status changes for envelopes in the account. If no entry, the system uses the time of the call as the `to_date`.
      * @var ?string
      */
    protected ?string $to_date = null;

    /**
     * Gets to_date
     *
     * @return ?string
     */
    public function getToDate(): ?string
    {
        return $this->to_date;
    }

    /**
     * Sets to_date
     * @param ?string $to_date Optional date/time setting that specifies the date/time when the request stops for status changes for envelopes in the account. If no entry, the system uses the time of the call as the `to_date`.
     *
     * @return self
     */
    public function setToDate(?string $to_date): self
    {
        $this->to_date = $to_date;
        return $this;
    }
    /**
      * $transaction_ids If included in the query string, this is a comma separated list of envelope `transactionId`s.   If included in the `request_body`, this is a list of envelope `transactionId`s.   ###### Note: `transactionId`s are only valid in the DocuSign system for seven days.
      * @var ?string
      */
    protected ?string $transaction_ids = null;

    /**
     * Gets transaction_ids
     *
     * @return ?string
     */
    public function getTransactionIds(): ?string
    {
        return $this->transaction_ids;
    }

    /**
     * Sets transaction_ids
     * @param ?string $transaction_ids If included in the query string, this is a comma separated list of envelope `transactionId`s.   If included in the `request_body`, this is a list of envelope `transactionId`s.   ###### Note: `transactionId`s are only valid in the DocuSign system for seven days.
     *
     * @return self
     */
    public function setTransactionIds(?string $transaction_ids): self
    {
        $this->transaction_ids = $transaction_ids;
        return $this;
    }
    /**
      * $user_filter 
      * @var ?string
      */
    protected ?string $user_filter = null;

    /**
     * Gets user_filter
     *
     * @return ?string
     */
    public function getUserFilter(): ?string
    {
        return $this->user_filter;
    }

    /**
     * Sets user_filter
     * @param ?string $user_filter 
     *
     * @return self
     */
    public function setUserFilter(?string $user_filter): self
    {
        $this->user_filter = $user_filter;
        return $this;
    }
    /**
      * $user_id 
      * @var ?string
      */
    protected ?string $user_id = null;

    /**
     * Gets user_id
     *
     * @return ?string
     */
    public function getUserId(): ?string
    {
        return $this->user_id;
    }

    /**
     * Sets user_id
     * @param ?string $user_id 
     *
     * @return self
     */
    public function setUserId(?string $user_id): self
    {
        $this->user_id = $user_id;
        return $this;
    }
    /**
      * $user_name 
      * @var ?string
      */
    protected ?string $user_name = null;

    /**
     * Gets user_name
     *
     * @return ?string
     */
    public function getUserName(): ?string
    {
        return $this->user_name;
    }

    /**
     * Sets user_name
     * @param ?string $user_name 
     *
     * @return self
     */
    public function setUserName(?string $user_name): self
    {
        $this->user_name = $user_name;
        return $this;
    }
}


/**
 * ListTabsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListTabsOptions
{
    /**
      * $include_anchor_tab_locations When set to **true**, all tabs with anchor tab properties are included in the response.
      * @var ?string
      */
    protected ?string $include_anchor_tab_locations = null;

    /**
     * Gets include_anchor_tab_locations
     *
     * @return ?string
     */
    public function getIncludeAnchorTabLocations(): ?string
    {
        return $this->include_anchor_tab_locations;
    }

    /**
     * Sets include_anchor_tab_locations
     * @param ?string $include_anchor_tab_locations When set to **true**, all tabs with anchor tab properties are included in the response.
     *
     * @return self
     */
    public function setIncludeAnchorTabLocations(?string $include_anchor_tab_locations): self
    {
        $this->include_anchor_tab_locations = $include_anchor_tab_locations;
        return $this;
    }
    /**
      * $include_metadata 
      * @var ?string
      */
    protected ?string $include_metadata = null;

    /**
     * Gets include_metadata
     *
     * @return ?string
     */
    public function getIncludeMetadata(): ?string
    {
        return $this->include_metadata;
    }

    /**
     * Sets include_metadata
     * @param ?string $include_metadata 
     *
     * @return self
     */
    public function setIncludeMetadata(?string $include_metadata): self
    {
        $this->include_metadata = $include_metadata;
        return $this;
    }
}


/**
 * ListTemplatesOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListTemplatesOptions
{
    /**
      * $include The possible values are:  matching_applied - This returns template matching information for the template.
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include The possible values are:  matching_applied - This returns template matching information for the template.
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
}


/**
 * ListTemplatesForDocumentOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ListTemplatesForDocumentOptions
{
    /**
      * $include 
      * @var ?string
      */
    protected ?string $include = null;

    /**
     * Gets include
     *
     * @return ?string
     */
    public function getInclude(): ?string
    {
        return $this->include;
    }

    /**
     * Sets include
     * @param ?string $include 
     *
     * @return self
     */
    public function setInclude(?string $include): self
    {
        $this->include = $include;
        return $this;
    }
}


/**
 * UpdateOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateOptions
{
    /**
      * $advanced_update When set to **true**, allows the caller to update recipients, tabs, custom fields, notification, email settings and other envelope attributes.
      * @var ?string
      */
    protected ?string $advanced_update = null;

    /**
     * Gets advanced_update
     *
     * @return ?string
     */
    public function getAdvancedUpdate(): ?string
    {
        return $this->advanced_update;
    }

    /**
     * Sets advanced_update
     * @param ?string $advanced_update When set to **true**, allows the caller to update recipients, tabs, custom fields, notification, email settings and other envelope attributes.
     *
     * @return self
     */
    public function setAdvancedUpdate(?string $advanced_update): self
    {
        $this->advanced_update = $advanced_update;
        return $this;
    }
    /**
      * $resend_envelope When set to **true**, sends the specified envelope again.
      * @var ?string
      */
    protected ?string $resend_envelope = null;

    /**
     * Gets resend_envelope
     *
     * @return ?string
     */
    public function getResendEnvelope(): ?string
    {
        return $this->resend_envelope;
    }

    /**
     * Sets resend_envelope
     * @param ?string $resend_envelope When set to **true**, sends the specified envelope again.
     *
     * @return self
     */
    public function setResendEnvelope(?string $resend_envelope): self
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}


/**
 * UpdateChunkedUploadOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateChunkedUploadOptions
{
    /**
      * $action 
      * @var ?string
      */
    protected ?string $action = null;

    /**
     * Gets action
     *
     * @return ?string
     */
    public function getAction(): ?string
    {
        return $this->action;
    }

    /**
     * Sets action
     * @param ?string $action 
     *
     * @return self
     */
    public function setAction(?string $action): self
    {
        $this->action = $action;
        return $this;
    }
}


/**
 * UpdateEnvelopeDocGenFormFieldsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateEnvelopeDocGenFormFieldsOptions
{
    /**
      * $update_docgen_formfields_only 
      * @var ?string
      */
    protected ?string $update_docgen_formfields_only = null;

    /**
     * Gets update_docgen_formfields_only
     *
     * @return ?string
     */
    public function getUpdateDocgenFormfieldsOnly(): ?string
    {
        return $this->update_docgen_formfields_only;
    }

    /**
     * Sets update_docgen_formfields_only
     * @param ?string $update_docgen_formfields_only 
     *
     * @return self
     */
    public function setUpdateDocgenFormfieldsOnly(?string $update_docgen_formfields_only): self
    {
        $this->update_docgen_formfields_only = $update_docgen_formfields_only;
        return $this;
    }
}


/**
 * UpdateRecipientsOptions Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class UpdateRecipientsOptions
{
    /**
      * $combine_same_order_recipients 
      * @var ?string
      */
    protected ?string $combine_same_order_recipients = null;

    /**
     * Gets combine_same_order_recipients
     *
     * @return ?string
     */
    public function getCombineSameOrderRecipients(): ?string
    {
        return $this->combine_same_order_recipients;
    }

    /**
     * Sets combine_same_order_recipients
     * @param ?string $combine_same_order_recipients 
     *
     * @return self
     */
    public function setCombineSameOrderRecipients(?string $combine_same_order_recipients): self
    {
        $this->combine_same_order_recipients = $combine_same_order_recipients;
        return $this;
    }
    /**
      * $offline_signing 
      * @var ?string
      */
    protected ?string $offline_signing = null;

    /**
     * Gets offline_signing
     *
     * @return ?string
     */
    public function getOfflineSigning(): ?string
    {
        return $this->offline_signing;
    }

    /**
     * Sets offline_signing
     * @param ?string $offline_signing 
     *
     * @return self
     */
    public function setOfflineSigning(?string $offline_signing): self
    {
        $this->offline_signing = $offline_signing;
        return $this;
    }
    /**
      * $resend_envelope When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope's next recipient.
      * @var ?string
      */
    protected ?string $resend_envelope = null;

    /**
     * Gets resend_envelope
     *
     * @return ?string
     */
    public function getResendEnvelope(): ?string
    {
        return $this->resend_envelope;
    }

    /**
     * Sets resend_envelope
     * @param ?string $resend_envelope When set to **true**, resends the   envelope if the new recipient's routing order is before or the same as the envelope's next recipient.
     *
     * @return self
     */
    public function setResendEnvelope(?string $resend_envelope): self
    {
        $this->resend_envelope = $resend_envelope;
        return $this;
    }
}



namespace DocuSign\eSign\Api;

use DocuSign\eSign\Client\ApiClient;
use DocuSign\eSign\Client\ApiException;
use DocuSign\eSign\Configuration;
use DocuSign\eSign\ObjectSerializer;

/**
 * EnvelopesApi Class Doc Comment
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class EnvelopesApi
{
    /**
     * API Client
     *
     * @var ApiClient instance of the ApiClient
     */
    protected ApiClient $apiClient;

    /**
     * Constructor
     *
     * @param ApiClient|null $apiClient The api client to use
     *
     * @return void
     */
    public function __construct(ApiClient $apiClient = null)
    {
        $this->apiClient = $apiClient ?? new ApiClient();
    }

    /**
     * Get API client
     *
     * @return ApiClient get the API client
     */
    public function getApiClient(): ApiClient
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param ApiClient $apiClient set the API client
     *
     * @return self
     */
    public function setApiClient(ApiClient $apiClient): self
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
    * Update $resourcePath with $
    *
    * @param string $resourcePath the resource path to use
    * @param string $baseName the base name param
    * @param string $paramName the parameter name
    *
    * @return string
    */
    public function updateResourcePath(string $resourcePath, string $baseName, string $paramName): string
    {
        return str_replace(
            "{" . $baseName . "}",
            $this->apiClient->getSerializer()->toPathValue($paramName),
            $resourcePath
        );
    }


    /**
     * Operation applyTemplate
     *
     * Adds templates to an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentTemplateList $document_template_list  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ApplyTemplateOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentTemplateList
     */
    public function applyTemplate($account_id, $envelope_id, $document_template_list = null, \DocuSign\eSign\Api\EnvelopesApi\ApplyTemplateOptions $options = null)
    {
        list($response) = $this->applyTemplateWithHttpInfo($account_id, $envelope_id, $document_template_list, $options);
        return $response;
    }

    /**
     * Operation applyTemplateWithHttpInfo
     *
     * Adds templates to an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentTemplateList $document_template_list  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ApplyTemplateOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentTemplateList, HTTP status code, HTTP response headers (array of strings)
     */
    public function applyTemplateWithHttpInfo($account_id, $envelope_id, $document_template_list = null, \DocuSign\eSign\Api\EnvelopesApi\ApplyTemplateOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling applyTemplate');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling applyTemplate');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getPreserveTemplateRecipient() != 'null') {
                $queryParams['preserve_template_recipient'] = $this->apiClient->getSerializer()->toQueryValue($options->getPreserveTemplateRecipient());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_template_list)) {
            $_tempBody = $document_template_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentTemplateList',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentTemplateList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentTemplateList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation applyTemplateToDocument
     *
     * Adds templates to a document in an  envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentTemplateList $document_template_list  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ApplyTemplateToDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentTemplateList
     */
    public function applyTemplateToDocument($account_id, $document_id, $envelope_id, $document_template_list = null, \DocuSign\eSign\Api\EnvelopesApi\ApplyTemplateToDocumentOptions $options = null)
    {
        list($response) = $this->applyTemplateToDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $document_template_list, $options);
        return $response;
    }

    /**
     * Operation applyTemplateToDocumentWithHttpInfo
     *
     * Adds templates to a document in an  envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentTemplateList $document_template_list  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ApplyTemplateToDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentTemplateList, HTTP status code, HTTP response headers (array of strings)
     */
    public function applyTemplateToDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $document_template_list = null, \DocuSign\eSign\Api\EnvelopesApi\ApplyTemplateToDocumentOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling applyTemplateToDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling applyTemplateToDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling applyTemplateToDocument');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getPreserveTemplateRecipient() != 'null') {
                $queryParams['preserve_template_recipient'] = $this->apiClient->getSerializer()->toQueryValue($options->getPreserveTemplateRecipient());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_template_list)) {
            $_tempBody = $document_template_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentTemplateList',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentTemplateList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentTemplateList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createChunkedUpload
     *
     * Initiate a new ChunkedUpload.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ChunkedUploadRequest $chunked_upload_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function createChunkedUpload($account_id, $chunked_upload_request = null)
    {
        list($response) = $this->createChunkedUploadWithHttpInfo($account_id, $chunked_upload_request);
        return $response;
    }

    /**
     * Operation createChunkedUploadWithHttpInfo
     *
     * Initiate a new ChunkedUpload.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ChunkedUploadRequest $chunked_upload_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createChunkedUploadWithHttpInfo($account_id, $chunked_upload_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createChunkedUpload');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/chunked_uploads";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($chunked_upload_request)) {
            $_tempBody = $chunked_upload_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2.1/accounts/{accountId}/chunked_uploads'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createConsoleView
     *
     * Returns a URL to the authentication view UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConsoleViewRequest $console_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createConsoleView($account_id, $console_view_request = null)
    {
        list($response) = $this->createConsoleViewWithHttpInfo($account_id, $console_view_request);
        return $response;
    }

    /**
     * Operation createConsoleViewWithHttpInfo
     *
     * Returns a URL to the authentication view UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConsoleViewRequest $console_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createConsoleViewWithHttpInfo($account_id, $console_view_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createConsoleView');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/views/console";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($console_view_request)) {
            $_tempBody = $console_view_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/views/console'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createCorrectView
     *
     * Returns a URL to the envelope correction UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CorrectViewRequest $correct_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createCorrectView($account_id, $envelope_id, $correct_view_request = null)
    {
        list($response) = $this->createCorrectViewWithHttpInfo($account_id, $envelope_id, $correct_view_request);
        return $response;
    }

    /**
     * Operation createCorrectViewWithHttpInfo
     *
     * Returns a URL to the envelope correction UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CorrectViewRequest $correct_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCorrectViewWithHttpInfo($account_id, $envelope_id, $correct_view_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createCorrectView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createCorrectView');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($correct_view_request)) {
            $_tempBody = $correct_view_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createCustomFields
     *
     * Updates envelope custom fields for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function createCustomFields($account_id, $envelope_id, $custom_fields = null)
    {
        list($response) = $this->createCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields);
        return $response;
    }

    /**
     * Operation createCustomFieldsWithHttpInfo
     *
     * Updates envelope custom fields for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function createCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createCustomFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($custom_fields)) {
            $_tempBody = $custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createDocumentFields
     *
     * Creates custom document fields in an existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function createDocumentFields($account_id, $document_id, $envelope_id, $document_fields_information = null)
    {
        list($response) = $this->createDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation createDocumentFieldsWithHttpInfo
     *
     * Creates custom document fields in an existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling createDocumentFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createDocumentResponsiveHtmlPreview
     *
     * Get Responsive HTML Preview for a document in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentHtmlDefinition $document_html_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentHtmlDefinitions
     */
    public function createDocumentResponsiveHtmlPreview($account_id, $document_id, $envelope_id, $document_html_definition = null)
    {
        list($response) = $this->createDocumentResponsiveHtmlPreviewWithHttpInfo($account_id, $document_id, $envelope_id, $document_html_definition);
        return $response;
    }

    /**
     * Operation createDocumentResponsiveHtmlPreviewWithHttpInfo
     *
     * Get Responsive HTML Preview for a document in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentHtmlDefinition $document_html_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentHtmlDefinitions, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDocumentResponsiveHtmlPreviewWithHttpInfo($account_id, $document_id, $envelope_id, $document_html_definition = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createDocumentResponsiveHtmlPreview');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling createDocumentResponsiveHtmlPreview');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createDocumentResponsiveHtmlPreview');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/responsive_html_preview";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_html_definition)) {
            $_tempBody = $document_html_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentHtmlDefinitions',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/responsive_html_preview'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentHtmlDefinitions', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentHtmlDefinitions', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createDocumentTabs
     *
     * Adds the tabs to an envelope document
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function createDocumentTabs($account_id, $document_id, $envelope_id, $tabs = null)
    {
        list($response) = $this->createDocumentTabsWithHttpInfo($account_id, $document_id, $envelope_id, $tabs);
        return $response;
    }

    /**
     * Operation createDocumentTabsWithHttpInfo
     *
     * Adds the tabs to an envelope document
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDocumentTabsWithHttpInfo($account_id, $document_id, $envelope_id, $tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createDocumentTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling createDocumentTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createDocumentTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($tabs)) {
            $_tempBody = $tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEditView
     *
     * Returns a URL to the edit view UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createEditView($account_id, $envelope_id, $return_url_request = null)
    {
        list($response) = $this->createEditViewWithHttpInfo($account_id, $envelope_id, $return_url_request);
        return $response;
    }

    /**
     * Operation createEditViewWithHttpInfo
     *
     * Returns a URL to the edit view UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEditViewWithHttpInfo($account_id, $envelope_id, $return_url_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEditView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createEditView');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/edit";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($return_url_request)) {
            $_tempBody = $return_url_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/edit'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEmailSettings
     *
     * Adds email setting overrides to an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function createEmailSettings($account_id, $envelope_id, $email_settings = null)
    {
        list($response) = $this->createEmailSettingsWithHttpInfo($account_id, $envelope_id, $email_settings);
        return $response;
    }

    /**
     * Operation createEmailSettingsWithHttpInfo
     *
     * Adds email setting overrides to an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EmailSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmailSettingsWithHttpInfo($account_id, $envelope_id, $email_settings = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEmailSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createEmailSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($email_settings)) {
            $_tempBody = $email_settings;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EmailSettings',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EmailSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EmailSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEnvelope
     *
     * Creates an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\CreateEnvelopeOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeSummary
     */
    public function createEnvelope($account_id, $envelope_definition = null, \DocuSign\eSign\Api\EnvelopesApi\CreateEnvelopeOptions $options = null)
    {
        list($response) = $this->createEnvelopeWithHttpInfo($account_id, $envelope_definition, $options);
        return $response;
    }

    /**
     * Operation createEnvelopeWithHttpInfo
     *
     * Creates an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\CreateEnvelopeOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEnvelopeWithHttpInfo($account_id, $envelope_definition = null, \DocuSign\eSign\Api\EnvelopesApi\CreateEnvelopeOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEnvelope');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCdseMode() != 'null') {
                $queryParams['cdse_mode'] = $this->apiClient->getSerializer()->toQueryValue($options->getCdseMode());
            }
            if ($options->getChangeRoutingOrder() != 'null') {
                $queryParams['change_routing_order'] = $this->apiClient->getSerializer()->toQueryValue($options->getChangeRoutingOrder());
            }
            if ($options->getCompletedDocumentsOnly() != 'null') {
                $queryParams['completed_documents_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getCompletedDocumentsOnly());
            }
            if ($options->getMergeRolesOnDraft() != 'null') {
                $queryParams['merge_roles_on_draft'] = $this->apiClient->getSerializer()->toQueryValue($options->getMergeRolesOnDraft());
            }
            if ($options->getTabLabelExactMatches() != 'null') {
                $queryParams['tab_label_exact_matches'] = $this->apiClient->getSerializer()->toQueryValue($options->getTabLabelExactMatches());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeSummary',
                '/v2.1/accounts/{accountId}/envelopes'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEnvelopeComments
     *
     * Posts a list of comments for authorized user
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CommentsPublish $comments_publish  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CommentHistoryResult
     */
    public function createEnvelopeComments($account_id, $envelope_id, $comments_publish = null)
    {
        list($response) = $this->createEnvelopeCommentsWithHttpInfo($account_id, $envelope_id, $comments_publish);
        return $response;
    }

    /**
     * Operation createEnvelopeCommentsWithHttpInfo
     *
     * Posts a list of comments for authorized user
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CommentsPublish $comments_publish  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CommentHistoryResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEnvelopeCommentsWithHttpInfo($account_id, $envelope_id, $comments_publish = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEnvelopeComments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createEnvelopeComments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($comments_publish)) {
            $_tempBody = $comments_publish;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CommentHistoryResult',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CommentHistoryResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CommentHistoryResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEnvelopeRecipientPreview
     *
     * Provides a URL to start a recipient view of the Envelope UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\RecipientPreviewRequest $recipient_preview_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createEnvelopeRecipientPreview($account_id, $envelope_id, $recipient_preview_request = null)
    {
        list($response) = $this->createEnvelopeRecipientPreviewWithHttpInfo($account_id, $envelope_id, $recipient_preview_request);
        return $response;
    }

    /**
     * Operation createEnvelopeRecipientPreviewWithHttpInfo
     *
     * Provides a URL to start a recipient view of the Envelope UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\RecipientPreviewRequest $recipient_preview_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEnvelopeRecipientPreviewWithHttpInfo($account_id, $envelope_id, $recipient_preview_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEnvelopeRecipientPreview');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createEnvelopeRecipientPreview');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient_preview";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($recipient_preview_request)) {
            $_tempBody = $recipient_preview_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient_preview'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEnvelopeRecipientSharedView
     *
     * Provides a URL to start a shared recipient view of the Envelope UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\RecipientViewRequest $recipient_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createEnvelopeRecipientSharedView($account_id, $envelope_id, $recipient_view_request = null)
    {
        list($response) = $this->createEnvelopeRecipientSharedViewWithHttpInfo($account_id, $envelope_id, $recipient_view_request);
        return $response;
    }

    /**
     * Operation createEnvelopeRecipientSharedViewWithHttpInfo
     *
     * Provides a URL to start a shared recipient view of the Envelope UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\RecipientViewRequest $recipient_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEnvelopeRecipientSharedViewWithHttpInfo($account_id, $envelope_id, $recipient_view_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEnvelopeRecipientSharedView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createEnvelopeRecipientSharedView');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/shared";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($recipient_view_request)) {
            $_tempBody = $recipient_view_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/shared'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEnvelopeTransferRules
     *
     * Add envelope transfer rules to an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeTransferRuleRequest $envelope_transfer_rule_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeTransferRuleInformation
     */
    public function createEnvelopeTransferRules($account_id, $envelope_transfer_rule_request = null)
    {
        list($response) = $this->createEnvelopeTransferRulesWithHttpInfo($account_id, $envelope_transfer_rule_request);
        return $response;
    }

    /**
     * Operation createEnvelopeTransferRulesWithHttpInfo
     *
     * Add envelope transfer rules to an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeTransferRuleRequest $envelope_transfer_rule_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeTransferRuleInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEnvelopeTransferRulesWithHttpInfo($account_id, $envelope_transfer_rule_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEnvelopeTransferRules');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_transfer_rule_request)) {
            $_tempBody = $envelope_transfer_rule_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeTransferRuleInformation',
                '/v2.1/accounts/{accountId}/envelopes/transfer_rules'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeTransferRuleInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeTransferRuleInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createEnvelopeWorkflowStepDefinition
     *
     * Creates and adds a new workflow step definition for an envelope's workflow
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\WorkflowStep $workflow_step  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkflowStep
     */
    public function createEnvelopeWorkflowStepDefinition($account_id, $envelope_id, $workflow_step = null)
    {
        list($response) = $this->createEnvelopeWorkflowStepDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step);
        return $response;
    }

    /**
     * Operation createEnvelopeWorkflowStepDefinitionWithHttpInfo
     *
     * Creates and adds a new workflow step definition for an envelope's workflow
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\WorkflowStep $workflow_step  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkflowStep, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEnvelopeWorkflowStepDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createEnvelopeWorkflowStepDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createEnvelopeWorkflowStepDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($workflow_step)) {
            $_tempBody = $workflow_step;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkflowStep',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkflowStep', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkflowStep', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createHistoricalEnvelopePublishTransaction
     *
     * Submits a batch of historical envelopes for republish to an adhoc config.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectHistoricalEnvelopeRepublish $connect_historical_envelope_republish  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopePublishTransaction
     */
    public function createHistoricalEnvelopePublishTransaction($account_id, $connect_historical_envelope_republish = null)
    {
        list($response) = $this->createHistoricalEnvelopePublishTransactionWithHttpInfo($account_id, $connect_historical_envelope_republish);
        return $response;
    }

    /**
     * Operation createHistoricalEnvelopePublishTransactionWithHttpInfo
     *
     * Submits a batch of historical envelopes for republish to an adhoc config.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\ConnectHistoricalEnvelopeRepublish $connect_historical_envelope_republish  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopePublishTransaction, HTTP status code, HTTP response headers (array of strings)
     */
    public function createHistoricalEnvelopePublishTransactionWithHttpInfo($account_id, $connect_historical_envelope_republish = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createHistoricalEnvelopePublishTransaction');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/connect/envelopes/publish/historical";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($connect_historical_envelope_republish)) {
            $_tempBody = $connect_historical_envelope_republish;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopePublishTransaction',
                '/v2.1/accounts/{accountId}/connect/envelopes/publish/historical'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopePublishTransaction', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopePublishTransaction', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createLock
     *
     * Lock an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function createLock($account_id, $envelope_id, $lock_request = null)
    {
        list($response) = $this->createLockWithHttpInfo($account_id, $envelope_id, $lock_request);
        return $response;
    }

    /**
     * Operation createLockWithHttpInfo
     *
     * Lock an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLockWithHttpInfo($account_id, $envelope_id, $lock_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createLock');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createLock');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRecipient
     *
     * Adds one or more recipients to an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\CreateRecipientOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function createRecipient($account_id, $envelope_id, $recipients = null, \DocuSign\eSign\Api\EnvelopesApi\CreateRecipientOptions $options = null)
    {
        list($response) = $this->createRecipientWithHttpInfo($account_id, $envelope_id, $recipients, $options);
        return $response;
    }

    /**
     * Operation createRecipientWithHttpInfo
     *
     * Adds one or more recipients to an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\CreateRecipientOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRecipientWithHttpInfo($account_id, $envelope_id, $recipients = null, \DocuSign\eSign\Api\EnvelopesApi\CreateRecipientOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createRecipient');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createRecipient');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getResendEnvelope() != 'null') {
                $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($recipients)) {
            $_tempBody = $recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRecipientManualReviewView
     *
     * Provides a link to access the Identity manual review related to a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createRecipientManualReviewView($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->createRecipientManualReviewViewWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation createRecipientManualReviewViewWithHttpInfo
     *
     * Provides a link to access the Identity manual review related to a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRecipientManualReviewViewWithHttpInfo($account_id, $envelope_id, $recipient_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createRecipientManualReviewView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createRecipientManualReviewView');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling createRecipientManualReviewView');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/views/identity_manual_review";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/views/identity_manual_review'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRecipientProofFileLink
     *
     * Returns a link to access to the identity events stored in the proof service related to this recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\IdEvidenceViewLink
     */
    public function createRecipientProofFileLink($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->createRecipientProofFileLinkWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation createRecipientProofFileLinkWithHttpInfo
     *
     * Returns a link to access to the identity events stored in the proof service related to this recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\IdEvidenceViewLink, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRecipientProofFileLinkWithHttpInfo($account_id, $envelope_id, $recipient_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createRecipientProofFileLink');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createRecipientProofFileLink');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling createRecipientProofFileLink');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\IdEvidenceViewLink',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\IdEvidenceViewLink', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\IdEvidenceViewLink', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRecipientProofFileResourceToken
     *
     * Returns a resource token to get access to the identity events stored in the proof service related to this recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $token_scopes 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\IdEvidenceResourceToken
     */
    public function createRecipientProofFileResourceToken($account_id, $envelope_id, $recipient_id, $token_scopes)
    {
        list($response) = $this->createRecipientProofFileResourceTokenWithHttpInfo($account_id, $envelope_id, $recipient_id, $token_scopes);
        return $response;
    }

    /**
     * Operation createRecipientProofFileResourceTokenWithHttpInfo
     *
     * Returns a resource token to get access to the identity events stored in the proof service related to this recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $token_scopes 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\IdEvidenceResourceToken, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRecipientProofFileResourceTokenWithHttpInfo($account_id, $envelope_id, $recipient_id, $token_scopes): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createRecipientProofFileResourceToken');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createRecipientProofFileResourceToken');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling createRecipientProofFileResourceToken');
        }
        // verify the required parameter 'token_scopes' is set
        if ($token_scopes === null) {
            throw new \InvalidArgumentException('Missing the required parameter $token_scopes when calling createRecipientProofFileResourceToken');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof_token";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }
        // path params
        if ($token_scopes !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "token_scopes", $token_scopes);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\IdEvidenceResourceToken',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/identity_proof_token'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\IdEvidenceResourceToken', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\IdEvidenceResourceToken', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createRecipientView
     *
     * Returns a URL to the recipient view UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\RecipientViewRequest $recipient_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createRecipientView($account_id, $envelope_id, $recipient_view_request = null)
    {
        list($response) = $this->createRecipientViewWithHttpInfo($account_id, $envelope_id, $recipient_view_request);
        return $response;
    }

    /**
     * Operation createRecipientViewWithHttpInfo
     *
     * Returns a URL to the recipient view UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\RecipientViewRequest $recipient_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRecipientViewWithHttpInfo($account_id, $envelope_id, $recipient_view_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createRecipientView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createRecipientView');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($recipient_view_request)) {
            $_tempBody = $recipient_view_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/recipient'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createResponsiveHtmlPreview
     *
     * Get Responsive HTML Preview for all documents in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentHtmlDefinition $document_html_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentHtmlDefinitions
     */
    public function createResponsiveHtmlPreview($account_id, $envelope_id, $document_html_definition = null)
    {
        list($response) = $this->createResponsiveHtmlPreviewWithHttpInfo($account_id, $envelope_id, $document_html_definition);
        return $response;
    }

    /**
     * Operation createResponsiveHtmlPreviewWithHttpInfo
     *
     * Get Responsive HTML Preview for all documents in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentHtmlDefinition $document_html_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentHtmlDefinitions, HTTP status code, HTTP response headers (array of strings)
     */
    public function createResponsiveHtmlPreviewWithHttpInfo($account_id, $envelope_id, $document_html_definition = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createResponsiveHtmlPreview');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createResponsiveHtmlPreview');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/responsive_html_preview";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_html_definition)) {
            $_tempBody = $document_html_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentHtmlDefinitions',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/responsive_html_preview'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentHtmlDefinitions', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentHtmlDefinitions', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createSenderView
     *
     * Returns a URL to the sender view UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ViewUrl
     */
    public function createSenderView($account_id, $envelope_id, $return_url_request = null)
    {
        list($response) = $this->createSenderViewWithHttpInfo($account_id, $envelope_id, $return_url_request);
        return $response;
    }

    /**
     * Operation createSenderViewWithHttpInfo
     *
     * Returns a URL to the sender view UI.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ReturnUrlRequest $return_url_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ViewUrl, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSenderViewWithHttpInfo($account_id, $envelope_id, $return_url_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createSenderView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createSenderView');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/sender";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($return_url_request)) {
            $_tempBody = $return_url_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ViewUrl',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/sender'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ViewUrl', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ViewUrl', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTabs
     *
     * Adds tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function createTabs($account_id, $envelope_id, $recipient_id, $tabs = null)
    {
        list($response) = $this->createTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs);
        return $response;
    }

    /**
     * Operation createTabsWithHttpInfo
     *
     * Adds tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling createTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling createTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($tabs)) {
            $_tempBody = $tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation createTemplateWorkflowStepDefinition
     *
     * Creates and adds a new workflow step definition for a template's workflow
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\WorkflowStep $workflow_step  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkflowStep
     */
    public function createTemplateWorkflowStepDefinition($account_id, $template_id, $workflow_step = null)
    {
        list($response) = $this->createTemplateWorkflowStepDefinitionWithHttpInfo($account_id, $template_id, $workflow_step);
        return $response;
    }

    /**
     * Operation createTemplateWorkflowStepDefinitionWithHttpInfo
     *
     * Creates and adds a new workflow step definition for a template's workflow
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\WorkflowStep $workflow_step  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkflowStep, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTemplateWorkflowStepDefinitionWithHttpInfo($account_id, $template_id, $workflow_step = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling createTemplateWorkflowStepDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling createTemplateWorkflowStepDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($workflow_step)) {
            $_tempBody = $workflow_step;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkflowStep',
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkflowStep', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkflowStep', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteAttachments
     *
     * Delete one or more attachments from a DRAFT envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeAttachmentsRequest $envelope_attachments_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAttachmentsResult
     */
    public function deleteAttachments($account_id, $envelope_id, $envelope_attachments_request = null)
    {
        list($response) = $this->deleteAttachmentsWithHttpInfo($account_id, $envelope_id, $envelope_attachments_request);
        return $response;
    }

    /**
     * Operation deleteAttachmentsWithHttpInfo
     *
     * Delete one or more attachments from a DRAFT envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeAttachmentsRequest $envelope_attachments_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAttachmentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAttachmentsWithHttpInfo($account_id, $envelope_id, $envelope_attachments_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteAttachments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteAttachments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_attachments_request)) {
            $_tempBody = $envelope_attachments_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAttachmentsResult',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteChunkedUpload
     *
     * Delete an existing ChunkedUpload.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $chunked_upload_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function deleteChunkedUpload($account_id, $chunked_upload_id)
    {
        list($response) = $this->deleteChunkedUploadWithHttpInfo($account_id, $chunked_upload_id);
        return $response;
    }

    /**
     * Operation deleteChunkedUploadWithHttpInfo
     *
     * Delete an existing ChunkedUpload.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $chunked_upload_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteChunkedUploadWithHttpInfo($account_id, $chunked_upload_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteChunkedUpload');
        }
        // verify the required parameter 'chunked_upload_id' is set
        if ($chunked_upload_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_id when calling deleteChunkedUpload');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($chunked_upload_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "chunkedUploadId", $chunked_upload_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteCustomFields
     *
     * Deletes envelope custom fields for draft and in-process envelopes.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function deleteCustomFields($account_id, $envelope_id, $custom_fields = null)
    {
        list($response) = $this->deleteCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields);
        return $response;
    }

    /**
     * Operation deleteCustomFieldsWithHttpInfo
     *
     * Deletes envelope custom fields for draft and in-process envelopes.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteCustomFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($custom_fields)) {
            $_tempBody = $custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocumentFields
     *
     * Deletes custom document fields from an existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function deleteDocumentFields($account_id, $document_id, $envelope_id, $document_fields_information = null)
    {
        list($response) = $this->deleteDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation deleteDocumentFieldsWithHttpInfo
     *
     * Deletes custom document fields from an existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteDocumentFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocumentPage
     *
     * Deletes a page from a document in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $page_number The page number being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteDocumentPage($account_id, $document_id, $envelope_id, $page_number)
    {
        list($response) = $this->deleteDocumentPageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number);
        return $response;
    }

    /**
     * Operation deleteDocumentPageWithHttpInfo
     *
     * Deletes a page from a document in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $page_number The page number being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentPageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteDocumentPage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling deleteDocumentPage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "pageNumber", $page_number);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocumentTabs
     *
     * Deletes tabs from an envelope document
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function deleteDocumentTabs($account_id, $document_id, $envelope_id, $tabs = null)
    {
        list($response) = $this->deleteDocumentTabsWithHttpInfo($account_id, $document_id, $envelope_id, $tabs);
        return $response;
    }

    /**
     * Operation deleteDocumentTabsWithHttpInfo
     *
     * Deletes tabs from an envelope document
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentTabsWithHttpInfo($account_id, $document_id, $envelope_id, $tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocumentTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteDocumentTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteDocumentTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($tabs)) {
            $_tempBody = $tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteDocuments
     *
     * Deletes documents from a draft envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeDocumentsResult
     */
    public function deleteDocuments($account_id, $envelope_id, $envelope_definition = null)
    {
        list($response) = $this->deleteDocumentsWithHttpInfo($account_id, $envelope_id, $envelope_definition);
        return $response;
    }

    /**
     * Operation deleteDocumentsWithHttpInfo
     *
     * Deletes documents from a draft envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteDocumentsWithHttpInfo($account_id, $envelope_id, $envelope_definition = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteDocuments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteDocuments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeDocumentsResult',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEmailSettings
     *
     * Deletes the email setting overrides for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function deleteEmailSettings($account_id, $envelope_id)
    {
        list($response) = $this->deleteEmailSettingsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation deleteEmailSettingsWithHttpInfo
     *
     * Deletes the email setting overrides for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EmailSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmailSettingsWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEmailSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteEmailSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EmailSettings',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EmailSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EmailSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEnvelopeCorrectView
     *
     * Revokes the correction view URL to the Envelope UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CorrectViewRequest $correct_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteEnvelopeCorrectView($account_id, $envelope_id, $correct_view_request = null)
    {
        list($response) = $this->deleteEnvelopeCorrectViewWithHttpInfo($account_id, $envelope_id, $correct_view_request);
        return $response;
    }

    /**
     * Operation deleteEnvelopeCorrectViewWithHttpInfo
     *
     * Revokes the correction view URL to the Envelope UI
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CorrectViewRequest $correct_view_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEnvelopeCorrectViewWithHttpInfo($account_id, $envelope_id, $correct_view_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEnvelopeCorrectView');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteEnvelopeCorrectView');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($correct_view_request)) {
            $_tempBody = $correct_view_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/views/correct'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEnvelopeDelayedRoutingDefinition
     *
     * Deletes the delayed routing rules for the specified envelope workflow step.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteEnvelopeDelayedRoutingDefinition($account_id, $envelope_id, $workflow_step_id)
    {
        list($response) = $this->deleteEnvelopeDelayedRoutingDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id);
        return $response;
    }

    /**
     * Operation deleteEnvelopeDelayedRoutingDefinitionWithHttpInfo
     *
     * Deletes the delayed routing rules for the specified envelope workflow step.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEnvelopeDelayedRoutingDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEnvelopeDelayedRoutingDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteEnvelopeDelayedRoutingDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling deleteEnvelopeDelayedRoutingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEnvelopeScheduledSendingDefinition
     *
     * Deletes the scheduled sending rules for the envelope's workflow.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteEnvelopeScheduledSendingDefinition($account_id, $envelope_id)
    {
        list($response) = $this->deleteEnvelopeScheduledSendingDefinitionWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation deleteEnvelopeScheduledSendingDefinitionWithHttpInfo
     *
     * Deletes the scheduled sending rules for the envelope's workflow.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEnvelopeScheduledSendingDefinitionWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEnvelopeScheduledSendingDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteEnvelopeScheduledSendingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEnvelopeTransferRules
     *
     * Delete envelope transfer rules for an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_transfer_rule_id 
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteEnvelopeTransferRules($account_id, $envelope_transfer_rule_id)
    {
        list($response) = $this->deleteEnvelopeTransferRulesWithHttpInfo($account_id, $envelope_transfer_rule_id);
        return $response;
    }

    /**
     * Operation deleteEnvelopeTransferRulesWithHttpInfo
     *
     * Delete envelope transfer rules for an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_transfer_rule_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEnvelopeTransferRulesWithHttpInfo($account_id, $envelope_transfer_rule_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEnvelopeTransferRules');
        }
        // verify the required parameter 'envelope_transfer_rule_id' is set
        if ($envelope_transfer_rule_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_transfer_rule_id when calling deleteEnvelopeTransferRules');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_transfer_rule_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeTransferRuleId", $envelope_transfer_rule_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEnvelopeWorkflowDefinition
     *
     * Delete the workflow definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteEnvelopeWorkflowDefinition($account_id, $envelope_id)
    {
        list($response) = $this->deleteEnvelopeWorkflowDefinitionWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation deleteEnvelopeWorkflowDefinitionWithHttpInfo
     *
     * Delete the workflow definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEnvelopeWorkflowDefinitionWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEnvelopeWorkflowDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteEnvelopeWorkflowDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteEnvelopeWorkflowStepDefinition
     *
     * Deletes the envelope workflow step definition for an envelope's workflow by step id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteEnvelopeWorkflowStepDefinition($account_id, $envelope_id, $workflow_step_id)
    {
        list($response) = $this->deleteEnvelopeWorkflowStepDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id);
        return $response;
    }

    /**
     * Operation deleteEnvelopeWorkflowStepDefinitionWithHttpInfo
     *
     * Deletes the envelope workflow step definition for an envelope's workflow by step id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEnvelopeWorkflowStepDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteEnvelopeWorkflowStepDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteEnvelopeWorkflowStepDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling deleteEnvelopeWorkflowStepDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteLock
     *
     * Deletes an envelope lock.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function deleteLock($account_id, $envelope_id)
    {
        list($response) = $this->deleteLockWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation deleteLockWithHttpInfo
     *
     * Deletes an envelope lock.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteLockWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteLock');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteLock');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRecipient
     *
     * Deletes a recipient from an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function deleteRecipient($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->deleteRecipientWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation deleteRecipientWithHttpInfo
     *
     * Deletes a recipient from an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRecipientWithHttpInfo($account_id, $envelope_id, $recipient_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteRecipient');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteRecipient');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling deleteRecipient');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteRecipients
     *
     * Deletes recipients from an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function deleteRecipients($account_id, $envelope_id, $recipients = null)
    {
        list($response) = $this->deleteRecipientsWithHttpInfo($account_id, $envelope_id, $recipients);
        return $response;
    }

    /**
     * Operation deleteRecipientsWithHttpInfo
     *
     * Deletes recipients from an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRecipientsWithHttpInfo($account_id, $envelope_id, $recipients = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteRecipients');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteRecipients');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($recipients)) {
            $_tempBody = $recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTabs
     *
     * Deletes the tabs associated with a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function deleteTabs($account_id, $envelope_id, $recipient_id, $tabs = null)
    {
        list($response) = $this->deleteTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs);
        return $response;
    }

    /**
     * Operation deleteTabsWithHttpInfo
     *
     * Deletes the tabs associated with a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling deleteTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($tabs)) {
            $_tempBody = $tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTemplateDelayedRoutingDefinition
     *
     * Deletes the delayed routing rules for the specified template workflow step.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteTemplateDelayedRoutingDefinition($account_id, $template_id, $workflow_step_id)
    {
        list($response) = $this->deleteTemplateDelayedRoutingDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id);
        return $response;
    }

    /**
     * Operation deleteTemplateDelayedRoutingDefinitionWithHttpInfo
     *
     * Deletes the delayed routing rules for the specified template workflow step.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTemplateDelayedRoutingDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTemplateDelayedRoutingDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteTemplateDelayedRoutingDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling deleteTemplateDelayedRoutingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTemplateScheduledSendingDefinition
     *
     * Deletes the scheduled sending rules for the template's workflow.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteTemplateScheduledSendingDefinition($account_id, $template_id)
    {
        list($response) = $this->deleteTemplateScheduledSendingDefinitionWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation deleteTemplateScheduledSendingDefinitionWithHttpInfo
     *
     * Deletes the scheduled sending rules for the template's workflow.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTemplateScheduledSendingDefinitionWithHttpInfo($account_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTemplateScheduledSendingDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteTemplateScheduledSendingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTemplateWorkflowDefinition
     *
     * Delete the workflow definition for a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteTemplateWorkflowDefinition($account_id, $template_id)
    {
        list($response) = $this->deleteTemplateWorkflowDefinitionWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation deleteTemplateWorkflowDefinitionWithHttpInfo
     *
     * Delete the workflow definition for a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTemplateWorkflowDefinitionWithHttpInfo($account_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTemplateWorkflowDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteTemplateWorkflowDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTemplateWorkflowStepDefinition
     *
     * Deletes the workflow step definition for an template's workflow by step id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteTemplateWorkflowStepDefinition($account_id, $template_id, $workflow_step_id)
    {
        list($response) = $this->deleteTemplateWorkflowStepDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id);
        return $response;
    }

    /**
     * Operation deleteTemplateWorkflowStepDefinitionWithHttpInfo
     *
     * Deletes the workflow step definition for an template's workflow by step id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTemplateWorkflowStepDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTemplateWorkflowStepDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteTemplateWorkflowStepDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling deleteTemplateWorkflowStepDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteTemplatesFromDocument
     *
     * Deletes a template from a document in an existing envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function deleteTemplatesFromDocument($account_id, $document_id, $envelope_id, $template_id)
    {
        list($response) = $this->deleteTemplatesFromDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $template_id);
        return $response;
    }

    /**
     * Operation deleteTemplatesFromDocumentWithHttpInfo
     *
     * Deletes a template from a document in an existing envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTemplatesFromDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling deleteTemplatesFromDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling deleteTemplatesFromDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling deleteTemplatesFromDocument');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling deleteTemplatesFromDocument');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates/{templateId}'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAttachment
     *
     * Retrieves an attachment from the envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $attachment_id 
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getAttachment($account_id, $attachment_id, $envelope_id)
    {
        list($response) = $this->getAttachmentWithHttpInfo($account_id, $attachment_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getAttachmentWithHttpInfo
     *
     * Retrieves an attachment from the envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $attachment_id 
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAttachmentWithHttpInfo($account_id, $attachment_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAttachment');
        }
        // verify the required parameter 'attachment_id' is set
        if ($attachment_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $attachment_id when calling getAttachment');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getAttachment');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/octet-stream']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($attachment_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "attachmentId", $attachment_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getAttachments
     *
     * Returns a list of attachments associated with the specified envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAttachmentsResult
     */
    public function getAttachments($account_id, $envelope_id)
    {
        list($response) = $this->getAttachmentsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getAttachmentsWithHttpInfo
     *
     * Returns a list of attachments associated with the specified envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAttachmentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAttachmentsWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getAttachments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getAttachments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAttachmentsResult',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getChunkedUpload
     *
     * Retrieves the current metadata of a ChunkedUpload.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $chunked_upload_id 
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetChunkedUploadOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function getChunkedUpload($account_id, $chunked_upload_id, \DocuSign\eSign\Api\EnvelopesApi\GetChunkedUploadOptions $options = null)
    {
        list($response) = $this->getChunkedUploadWithHttpInfo($account_id, $chunked_upload_id, $options);
        return $response;
    }

    /**
     * Operation getChunkedUploadWithHttpInfo
     *
     * Retrieves the current metadata of a ChunkedUpload.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $chunked_upload_id 
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetChunkedUploadOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getChunkedUploadWithHttpInfo($account_id, $chunked_upload_id, \DocuSign\eSign\Api\EnvelopesApi\GetChunkedUploadOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getChunkedUpload');
        }
        // verify the required parameter 'chunked_upload_id' is set
        if ($chunked_upload_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_id when calling getChunkedUpload');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($chunked_upload_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "chunkedUploadId", $chunked_upload_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getCommentsTranscript
     *
     * Gets comment transcript for envelope and user
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetCommentsTranscriptOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getCommentsTranscript($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetCommentsTranscriptOptions $options = null)
    {
        list($response) = $this->getCommentsTranscriptWithHttpInfo($account_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation getCommentsTranscriptWithHttpInfo
     *
     * Gets comment transcript for envelope and user
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetCommentsTranscriptOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCommentsTranscriptWithHttpInfo($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetCommentsTranscriptOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getCommentsTranscript');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getCommentsTranscript');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments/transcript";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/pdf']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getEncoding() != 'null') {
                $queryParams['encoding'] = $this->apiClient->getSerializer()->toQueryValue($options->getEncoding());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/comments/transcript'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConsumerDisclosure
     *
     * Reserved: Gets the Electronic Record and Signature Disclosure associated with the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to ï¿½browserï¿½ to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetConsumerDisclosureOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConsumerDisclosure
     */
    public function getConsumerDisclosure($account_id, $envelope_id, $lang_code, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\GetConsumerDisclosureOptions $options = null)
    {
        list($response) = $this->getConsumerDisclosureWithHttpInfo($account_id, $envelope_id, $lang_code, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation getConsumerDisclosureWithHttpInfo
     *
     * Reserved: Gets the Electronic Record and Signature Disclosure associated with the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $lang_code The simple type enumeration the language used in the response. The supported languages, with the language value shown in parenthesis, are:Arabic (ar), Armenian (hy), Bulgarian (bg), Czech (cs), Chinese Simplified (zh_CN), Chinese Traditional (zh_TW), Croatian (hr), Danish (da), Dutch (nl), English US (en), English UK (en_GB), Estonian (et), Farsi (fa), Finnish (fi), French (fr), French Canada (fr_CA), German (de), Greek (el), Hebrew (he), Hindi (hi), Hungarian (hu), Bahasa Indonesia (id), Italian (it), Japanese (ja), Korean (ko), Latvian (lv), Lithuanian (lt), Bahasa Melayu (ms), Norwegian (no), Polish (pl), Portuguese (pt), Portuguese Brazil (pt_BR), Romanian (ro), Russian (ru), Serbian (sr), Slovak (sk), Slovenian (sl), Spanish (es),Spanish Latin America (es_MX), Swedish (sv), Thai (th), Turkish (tr), Ukrainian (uk) and Vietnamese (vi). Additionally, the value can be set to ï¿½browserï¿½ to automatically detect the browser language being used by the viewer and display the disclosure in that language.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetConsumerDisclosureOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConsumerDisclosure, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsumerDisclosureWithHttpInfo($account_id, $envelope_id, $lang_code, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\GetConsumerDisclosureOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConsumerDisclosure');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getConsumerDisclosure');
        }
        // verify the required parameter 'lang_code' is set
        if ($lang_code === null) {
            throw new \InvalidArgumentException('Missing the required parameter $lang_code when calling getConsumerDisclosure');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getConsumerDisclosure');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure/{langCode}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getLangCode2() != 'null') {
                $queryParams['langCode'] = $this->apiClient->getSerializer()->toQueryValue($options->getLangCode2());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($lang_code !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "langCode", $lang_code);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConsumerDisclosure',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure/{langCode}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConsumerDisclosure', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConsumerDisclosure', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getConsumerDisclosureDefault
     *
     * Gets the Electronic Record and Signature Disclosure associated with the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetConsumerDisclosureDefaultOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ConsumerDisclosure
     */
    public function getConsumerDisclosureDefault($account_id, $envelope_id, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\GetConsumerDisclosureDefaultOptions $options = null)
    {
        list($response) = $this->getConsumerDisclosureDefaultWithHttpInfo($account_id, $envelope_id, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation getConsumerDisclosureDefaultWithHttpInfo
     *
     * Gets the Electronic Record and Signature Disclosure associated with the account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetConsumerDisclosureDefaultOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ConsumerDisclosure, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsumerDisclosureDefaultWithHttpInfo($account_id, $envelope_id, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\GetConsumerDisclosureDefaultOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getConsumerDisclosureDefault');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getConsumerDisclosureDefault');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getConsumerDisclosureDefault');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getLangCode() != 'null') {
                $queryParams['langCode'] = $this->apiClient->getSerializer()->toQueryValue($options->getLangCode());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ConsumerDisclosure',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/consumer_disclosure'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ConsumerDisclosure', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ConsumerDisclosure', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocument
     *
     * Gets a document from an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getDocument($account_id, $document_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetDocumentOptions $options = null)
    {
        list($response) = $this->getDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation getDocumentWithHttpInfo
     *
     * Gets a document from an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentWithHttpInfo($account_id, $document_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetDocumentOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getDocument');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/pdf']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCertificate() != 'null') {
                $queryParams['certificate'] = $this->apiClient->getSerializer()->toQueryValue($options->getCertificate());
            }
            if ($options->getDocumentsByUserid() != 'null') {
                $queryParams['documents_by_userid'] = $this->apiClient->getSerializer()->toQueryValue($options->getDocumentsByUserid());
            }
            if ($options->getEncoding() != 'null') {
                $queryParams['encoding'] = $this->apiClient->getSerializer()->toQueryValue($options->getEncoding());
            }
            if ($options->getEncrypt() != 'null') {
                $queryParams['encrypt'] = $this->apiClient->getSerializer()->toQueryValue($options->getEncrypt());
            }
            if ($options->getLanguage() != 'null') {
                $queryParams['language'] = $this->apiClient->getSerializer()->toQueryValue($options->getLanguage());
            }
            if ($options->getRecipientId() != 'null') {
                $queryParams['recipient_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getRecipientId());
            }
            if ($options->getSharedUserId() != 'null') {
                $queryParams['shared_user_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getSharedUserId());
            }
            if ($options->getShowChanges() != 'null') {
                $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
            }
            if ($options->getWatermark() != 'null') {
                $queryParams['watermark'] = $this->apiClient->getSerializer()->toQueryValue($options->getWatermark());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocumentPageImage
     *
     * Gets a page image from an envelope for display.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetDocumentPageImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getDocumentPageImage($account_id, $document_id, $envelope_id, $page_number, \DocuSign\eSign\Api\EnvelopesApi\GetDocumentPageImageOptions $options = null)
    {
        list($response) = $this->getDocumentPageImageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number, $options);
        return $response;
    }

    /**
     * Operation getDocumentPageImageWithHttpInfo
     *
     * Gets a page image from an envelope for display.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetDocumentPageImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentPageImageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number, \DocuSign\eSign\Api\EnvelopesApi\GetDocumentPageImageOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getDocumentPageImage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling getDocumentPageImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['image/png']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getDpi() != 'null') {
                $queryParams['dpi'] = $this->apiClient->getSerializer()->toQueryValue($options->getDpi());
            }
            if ($options->getMaxHeight() != 'null') {
                $queryParams['max_height'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxHeight());
            }
            if ($options->getMaxWidth() != 'null') {
                $queryParams['max_width'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxWidth());
            }
            if ($options->getShowChanges() != 'null') {
                $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "pageNumber", $page_number);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getDocumentTabs
     *
     * Returns tabs on the document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetDocumentTabsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function getDocumentTabs($account_id, $document_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetDocumentTabsOptions $options = null)
    {
        list($response) = $this->getDocumentTabsWithHttpInfo($account_id, $document_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation getDocumentTabsWithHttpInfo
     *
     * Returns tabs on the document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetDocumentTabsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDocumentTabsWithHttpInfo($account_id, $document_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetDocumentTabsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getDocumentTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getDocumentTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getDocumentTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeMetadata() != 'null') {
                $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
            }
            if ($options->getPageNumbers() != 'null') {
                $queryParams['page_numbers'] = $this->apiClient->getSerializer()->toQueryValue($options->getPageNumbers());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEmailSettings
     *
     * Gets the email setting overrides for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function getEmailSettings($account_id, $envelope_id)
    {
        list($response) = $this->getEmailSettingsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getEmailSettingsWithHttpInfo
     *
     * Gets the email setting overrides for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EmailSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmailSettingsWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEmailSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEmailSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EmailSettings',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EmailSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EmailSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelope
     *
     * Gets the status of a envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetEnvelopeOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Envelope
     */
    public function getEnvelope($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetEnvelopeOptions $options = null)
    {
        list($response) = $this->getEnvelopeWithHttpInfo($account_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation getEnvelopeWithHttpInfo
     *
     * Gets the status of a envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetEnvelopeOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Envelope, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeWithHttpInfo($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetEnvelopeOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelope');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEnvelope');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAdvancedUpdate() != 'null') {
                $queryParams['advanced_update'] = $this->apiClient->getSerializer()->toQueryValue($options->getAdvancedUpdate());
            }
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Envelope',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Envelope', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Envelope', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelopeDelayedRoutingDefinition
     *
     * Returns the delayed routing rules for an envelope's workflow step definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DelayedRouting
     */
    public function getEnvelopeDelayedRoutingDefinition($account_id, $envelope_id, $workflow_step_id)
    {
        list($response) = $this->getEnvelopeDelayedRoutingDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id);
        return $response;
    }

    /**
     * Operation getEnvelopeDelayedRoutingDefinitionWithHttpInfo
     *
     * Returns the delayed routing rules for an envelope's workflow step definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DelayedRouting, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeDelayedRoutingDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelopeDelayedRoutingDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEnvelopeDelayedRoutingDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling getEnvelopeDelayedRoutingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DelayedRouting',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DelayedRouting', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DelayedRouting', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelopeDocGenFormFields
     *
     * Returns formfields for an envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocGenFormFieldResponse
     */
    public function getEnvelopeDocGenFormFields($account_id, $envelope_id)
    {
        list($response) = $this->getEnvelopeDocGenFormFieldsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getEnvelopeDocGenFormFieldsWithHttpInfo
     *
     * Returns formfields for an envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocGenFormFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeDocGenFormFieldsWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelopeDocGenFormFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEnvelopeDocGenFormFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/docGenFormFields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocGenFormFieldResponse',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/docGenFormFields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocGenFormFieldResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocGenFormFieldResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelopeDocumentHtmlDefinitions
     *
     * Get the Original HTML Definition used to generate the Responsive HTML for a given document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals
     */
    public function getEnvelopeDocumentHtmlDefinitions($account_id, $document_id, $envelope_id)
    {
        list($response) = $this->getEnvelopeDocumentHtmlDefinitionsWithHttpInfo($account_id, $document_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getEnvelopeDocumentHtmlDefinitionsWithHttpInfo
     *
     * Get the Original HTML Definition used to generate the Responsive HTML for a given document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeDocumentHtmlDefinitionsWithHttpInfo($account_id, $document_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelopeDocumentHtmlDefinitions');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getEnvelopeDocumentHtmlDefinitions');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEnvelopeDocumentHtmlDefinitions');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/html_definitions";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/html_definitions'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelopeHtmlDefinitions
     *
     * Get the Original HTML Definition used to generate the Responsive HTML for the envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals
     */
    public function getEnvelopeHtmlDefinitions($account_id, $envelope_id)
    {
        list($response) = $this->getEnvelopeHtmlDefinitionsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getEnvelopeHtmlDefinitionsWithHttpInfo
     *
     * Get the Original HTML Definition used to generate the Responsive HTML for the envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeHtmlDefinitionsWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelopeHtmlDefinitions');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEnvelopeHtmlDefinitions');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/html_definitions";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/html_definitions'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentHtmlDefinitionOriginals', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelopeScheduledSendingDefinition
     *
     * Returns the scheduled sending rules for an envelope's workflow definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ScheduledSending
     */
    public function getEnvelopeScheduledSendingDefinition($account_id, $envelope_id)
    {
        list($response) = $this->getEnvelopeScheduledSendingDefinitionWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getEnvelopeScheduledSendingDefinitionWithHttpInfo
     *
     * Returns the scheduled sending rules for an envelope's workflow definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ScheduledSending, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeScheduledSendingDefinitionWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelopeScheduledSendingDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEnvelopeScheduledSendingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ScheduledSending',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ScheduledSending', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ScheduledSending', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelopeTransferRules
     *
     * Returns a list of envelope transfer rules in the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetEnvelopeTransferRulesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeTransferRuleInformation
     */
    public function getEnvelopeTransferRules($account_id, \DocuSign\eSign\Api\EnvelopesApi\GetEnvelopeTransferRulesOptions $options = null)
    {
        list($response) = $this->getEnvelopeTransferRulesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation getEnvelopeTransferRulesWithHttpInfo
     *
     * Returns a list of envelope transfer rules in the specified account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetEnvelopeTransferRulesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeTransferRuleInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeTransferRulesWithHttpInfo($account_id, \DocuSign\eSign\Api\EnvelopesApi\GetEnvelopeTransferRulesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelopeTransferRules');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeTransferRuleInformation',
                '/v2.1/accounts/{accountId}/envelopes/transfer_rules'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeTransferRuleInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeTransferRuleInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelopeWorkflowDefinition
     *
     * Returns the workflow definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workflow
     */
    public function getEnvelopeWorkflowDefinition($account_id, $envelope_id)
    {
        list($response) = $this->getEnvelopeWorkflowDefinitionWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getEnvelopeWorkflowDefinitionWithHttpInfo
     *
     * Returns the workflow definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workflow, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeWorkflowDefinitionWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelopeWorkflowDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEnvelopeWorkflowDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workflow',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workflow', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workflow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getEnvelopeWorkflowStepDefinition
     *
     * Returns the workflow step definition for an envelope by step id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkflowStep
     */
    public function getEnvelopeWorkflowStepDefinition($account_id, $envelope_id, $workflow_step_id)
    {
        list($response) = $this->getEnvelopeWorkflowStepDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id);
        return $response;
    }

    /**
     * Operation getEnvelopeWorkflowStepDefinitionWithHttpInfo
     *
     * Returns the workflow step definition for an envelope by step id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkflowStep, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEnvelopeWorkflowStepDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getEnvelopeWorkflowStepDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getEnvelopeWorkflowStepDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling getEnvelopeWorkflowStepDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkflowStep',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkflowStep', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkflowStep', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFormData
     *
     * Returns envelope form data for an existing envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeFormData
     */
    public function getFormData($account_id, $envelope_id)
    {
        list($response) = $this->getFormDataWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getFormDataWithHttpInfo
     *
     * Returns envelope form data for an existing envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeFormData, HTTP status code, HTTP response headers (array of strings)
     */
    public function getFormDataWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getFormData');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getFormData');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/form_data";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeFormData',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/form_data'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeFormData', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeFormData', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getLock
     *
     * Gets envelope lock information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function getLock($account_id, $envelope_id)
    {
        list($response) = $this->getLockWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getLockWithHttpInfo
     *
     * Gets envelope lock information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLockWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getLock');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getLock');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getNotificationSettings
     *
     * Gets envelope notification information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Notification
     */
    public function getNotificationSettings($account_id, $envelope_id)
    {
        list($response) = $this->getNotificationSettingsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getNotificationSettingsWithHttpInfo
     *
     * Gets envelope notification information.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Notification, HTTP status code, HTTP response headers (array of strings)
     */
    public function getNotificationSettingsWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getNotificationSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getNotificationSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Notification',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Notification', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Notification', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPageTabs
     *
     * Returns tabs on the specified page.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $page_number The page number being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function getPageTabs($account_id, $document_id, $envelope_id, $page_number)
    {
        list($response) = $this->getPageTabsWithHttpInfo($account_id, $document_id, $envelope_id, $page_number);
        return $response;
    }

    /**
     * Operation getPageTabsWithHttpInfo
     *
     * Returns tabs on the specified page.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $page_number The page number being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPageTabsWithHttpInfo($account_id, $document_id, $envelope_id, $page_number): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPageTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getPageTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getPageTabs');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling getPageTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "pageNumber", $page_number);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getPages
     *
     * Returns document page image(s) based on input.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetPagesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\PageImages
     */
    public function getPages($account_id, $document_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetPagesOptions $options = null)
    {
        list($response) = $this->getPagesWithHttpInfo($account_id, $document_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation getPagesWithHttpInfo
     *
     * Returns document page image(s) based on input.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetPagesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\PageImages, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPagesWithHttpInfo($account_id, $document_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\GetPagesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getPages');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling getPages');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getPages');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getDpi() != 'null') {
                $queryParams['dpi'] = $this->apiClient->getSerializer()->toQueryValue($options->getDpi());
            }
            if ($options->getMaxHeight() != 'null') {
                $queryParams['max_height'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxHeight());
            }
            if ($options->getMaxWidth() != 'null') {
                $queryParams['max_width'] = $this->apiClient->getSerializer()->toQueryValue($options->getMaxWidth());
            }
            if ($options->getNocache() != 'null') {
                $queryParams['nocache'] = $this->apiClient->getSerializer()->toQueryValue($options->getNocache());
            }
            if ($options->getShowChanges() != 'null') {
                $queryParams['show_changes'] = $this->apiClient->getSerializer()->toQueryValue($options->getShowChanges());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\PageImages',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\PageImages', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\PageImages', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRecipientDocumentVisibility
     *
     * Returns document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentVisibilityList
     */
    public function getRecipientDocumentVisibility($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->getRecipientDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation getRecipientDocumentVisibilityWithHttpInfo
     *
     * Returns document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRecipientDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $recipient_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getRecipientDocumentVisibility');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getRecipientDocumentVisibility');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getRecipientDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentVisibilityList',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRecipientInitialsImage
     *
     * Gets the initials image for a user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetRecipientInitialsImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getRecipientInitialsImage($account_id, $envelope_id, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\GetRecipientInitialsImageOptions $options = null)
    {
        list($response) = $this->getRecipientInitialsImageWithHttpInfo($account_id, $envelope_id, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation getRecipientInitialsImageWithHttpInfo
     *
     * Gets the initials image for a user.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetRecipientInitialsImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRecipientInitialsImageWithHttpInfo($account_id, $envelope_id, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\GetRecipientInitialsImageOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getRecipientInitialsImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getRecipientInitialsImage');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getRecipientInitialsImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['image/gif']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeChrome() != 'null') {
                $queryParams['include_chrome'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeChrome());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRecipientSignature
     *
     * Gets signature information for a signer or sign-in-person recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\UserSignature
     */
    public function getRecipientSignature($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->getRecipientSignatureWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation getRecipientSignatureWithHttpInfo
     *
     * Gets signature information for a signer or sign-in-person recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\UserSignature, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRecipientSignatureWithHttpInfo($account_id, $envelope_id, $recipient_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getRecipientSignature');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getRecipientSignature');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getRecipientSignature');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\UserSignature',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\UserSignature', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\UserSignature', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getRecipientSignatureImage
     *
     * Retrieve signature image information for a signer/sign-in-person recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetRecipientSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \SplFileObject
     */
    public function getRecipientSignatureImage($account_id, $envelope_id, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\GetRecipientSignatureImageOptions $options = null)
    {
        list($response) = $this->getRecipientSignatureImageWithHttpInfo($account_id, $envelope_id, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation getRecipientSignatureImageWithHttpInfo
     *
     * Retrieve signature image information for a signer/sign-in-person recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\GetRecipientSignatureImageOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \SplFileObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRecipientSignatureImageWithHttpInfo($account_id, $envelope_id, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\GetRecipientSignatureImageOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getRecipientSignatureImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getRecipientSignatureImage');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getRecipientSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['image/gif']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeChrome() != 'null') {
                $queryParams['include_chrome'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeChrome());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\SplFileObject',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\SplFileObject', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\SplFileObject', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getTabsBlob
     *
     * Get encrypted tabs for envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function getTabsBlob($account_id, $envelope_id)
    {
        list($response) = $this->getTabsBlobWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation getTabsBlobWithHttpInfo
     *
     * Get encrypted tabs for envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTabsBlobWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getTabsBlob');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling getTabsBlob');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getTemplateDelayedRoutingDefinition
     *
     * Returns the delayed routing rules for a template's workflow step definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DelayedRouting
     */
    public function getTemplateDelayedRoutingDefinition($account_id, $template_id, $workflow_step_id)
    {
        list($response) = $this->getTemplateDelayedRoutingDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id);
        return $response;
    }

    /**
     * Operation getTemplateDelayedRoutingDefinitionWithHttpInfo
     *
     * Returns the delayed routing rules for a template's workflow step definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DelayedRouting, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTemplateDelayedRoutingDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getTemplateDelayedRoutingDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getTemplateDelayedRoutingDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling getTemplateDelayedRoutingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DelayedRouting',
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DelayedRouting', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DelayedRouting', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getTemplateRecipientDocumentVisibility
     *
     * Returns document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentVisibilityList
     */
    public function getTemplateRecipientDocumentVisibility($account_id, $recipient_id, $template_id)
    {
        list($response) = $this->getTemplateRecipientDocumentVisibilityWithHttpInfo($account_id, $recipient_id, $template_id);
        return $response;
    }

    /**
     * Operation getTemplateRecipientDocumentVisibilityWithHttpInfo
     *
     * Returns document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTemplateRecipientDocumentVisibilityWithHttpInfo($account_id, $recipient_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getTemplateRecipientDocumentVisibility');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling getTemplateRecipientDocumentVisibility');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getTemplateRecipientDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentVisibilityList',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getTemplateScheduledSendingDefinition
     *
     * Returns the scheduled sending rules for a template's workflow definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ScheduledSending
     */
    public function getTemplateScheduledSendingDefinition($account_id, $template_id)
    {
        list($response) = $this->getTemplateScheduledSendingDefinitionWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation getTemplateScheduledSendingDefinitionWithHttpInfo
     *
     * Returns the scheduled sending rules for a template's workflow definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ScheduledSending, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTemplateScheduledSendingDefinitionWithHttpInfo($account_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getTemplateScheduledSendingDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getTemplateScheduledSendingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ScheduledSending',
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ScheduledSending', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ScheduledSending', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getTemplateWorkflowDefinition
     *
     * Returns the workflow definition for a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workflow
     */
    public function getTemplateWorkflowDefinition($account_id, $template_id)
    {
        list($response) = $this->getTemplateWorkflowDefinitionWithHttpInfo($account_id, $template_id);
        return $response;
    }

    /**
     * Operation getTemplateWorkflowDefinitionWithHttpInfo
     *
     * Returns the workflow definition for a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workflow, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTemplateWorkflowDefinitionWithHttpInfo($account_id, $template_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getTemplateWorkflowDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getTemplateWorkflowDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workflow',
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workflow', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workflow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getTemplateWorkflowStepDefinition
     *
     * Returns the workflow step definition for a template by step id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkflowStep
     */
    public function getTemplateWorkflowStepDefinition($account_id, $template_id, $workflow_step_id)
    {
        list($response) = $this->getTemplateWorkflowStepDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id);
        return $response;
    }

    /**
     * Operation getTemplateWorkflowStepDefinitionWithHttpInfo
     *
     * Returns the workflow step definition for a template by step id.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkflowStep, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTemplateWorkflowStepDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling getTemplateWorkflowStepDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling getTemplateWorkflowStepDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling getTemplateWorkflowStepDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkflowStep',
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkflowStep', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkflowStep', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listAuditEvents
     *
     * Gets the envelope audit events for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAuditEventResponse
     */
    public function listAuditEvents($account_id, $envelope_id)
    {
        list($response) = $this->listAuditEventsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation listAuditEventsWithHttpInfo
     *
     * Gets the envelope audit events for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAuditEventResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function listAuditEventsWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listAuditEvents');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listAuditEvents');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/audit_events";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAuditEventResponse',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/audit_events'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAuditEventResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAuditEventResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listCustomFields
     *
     * Gets the custom field information for the specified envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFieldsEnvelope
     */
    public function listCustomFields($account_id, $envelope_id)
    {
        list($response) = $this->listCustomFieldsWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation listCustomFieldsWithHttpInfo
     *
     * Gets the custom field information for the specified envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFieldsEnvelope, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCustomFieldsWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listCustomFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFieldsEnvelope',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFieldsEnvelope', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFieldsEnvelope', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listDocumentFields
     *
     * Gets the custom document fields from an  existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function listDocumentFields($account_id, $document_id, $envelope_id)
    {
        list($response) = $this->listDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id);
        return $response;
    }

    /**
     * Operation listDocumentFieldsWithHttpInfo
     *
     * Gets the custom document fields from an  existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling listDocumentFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listDocuments
     *
     * Gets a list of envelope documents.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListDocumentsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeDocumentsResult
     */
    public function listDocuments($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\ListDocumentsOptions $options = null)
    {
        list($response) = $this->listDocumentsWithHttpInfo($account_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation listDocumentsWithHttpInfo
     *
     * Gets a list of envelope documents.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListDocumentsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function listDocumentsWithHttpInfo($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\ListDocumentsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listDocuments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listDocuments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getDocumentsByUserid() != 'null') {
                $queryParams['documents_by_userid'] = $this->apiClient->getSerializer()->toQueryValue($options->getDocumentsByUserid());
            }
            if ($options->getIncludeDocgenFormfields() != 'null') {
                $queryParams['include_docgen_formfields'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeDocgenFormfields());
            }
            if ($options->getIncludeDocumentSize() != 'null') {
                $queryParams['include_document_size'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeDocumentSize());
            }
            if ($options->getIncludeMetadata() != 'null') {
                $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
            }
            if ($options->getIncludeTabs() != 'null') {
                $queryParams['include_tabs'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeTabs());
            }
            if ($options->getRecipientId() != 'null') {
                $queryParams['recipient_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getRecipientId());
            }
            if ($options->getSharedUserId() != 'null') {
                $queryParams['shared_user_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getSharedUserId());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeDocumentsResult',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listRecipients
     *
     * Gets the status of recipients for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Recipients
     */
    public function listRecipients($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\ListRecipientsOptions $options = null)
    {
        list($response) = $this->listRecipientsWithHttpInfo($account_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation listRecipientsWithHttpInfo
     *
     * Gets the status of recipients for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Recipients, HTTP status code, HTTP response headers (array of strings)
     */
    public function listRecipientsWithHttpInfo($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\ListRecipientsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listRecipients');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listRecipients');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeAnchorTabLocations() != 'null') {
                $queryParams['include_anchor_tab_locations'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAnchorTabLocations());
            }
            if ($options->getIncludeExtended() != 'null') {
                $queryParams['include_extended'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeExtended());
            }
            if ($options->getIncludeMetadata() != 'null') {
                $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
            }
            if ($options->getIncludeTabs() != 'null') {
                $queryParams['include_tabs'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeTabs());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Recipients',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Recipients', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Recipients', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listStatus
     *
     * Gets the envelope status for the specified envelopes.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeIdsRequest $envelope_ids_request  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListStatusOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopesInformation
     */
    public function listStatus($account_id, $envelope_ids_request = null, \DocuSign\eSign\Api\EnvelopesApi\ListStatusOptions $options = null)
    {
        list($response) = $this->listStatusWithHttpInfo($account_id, $envelope_ids_request, $options);
        return $response;
    }

    /**
     * Operation listStatusWithHttpInfo
     *
     * Gets the envelope status for the specified envelopes.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeIdsRequest $envelope_ids_request  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListStatusOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listStatusWithHttpInfo($account_id, $envelope_ids_request = null, \DocuSign\eSign\Api\EnvelopesApi\ListStatusOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listStatus');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/status";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAcStatus() != 'null') {
                $queryParams['ac_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getAcStatus());
            }
            if ($options->getBlock() != 'null') {
                $queryParams['block'] = $this->apiClient->getSerializer()->toQueryValue($options->getBlock());
            }
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getEmail() != 'null') {
                $queryParams['email'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmail());
            }
            if ($options->getEnvelopeIds() != 'null') {
                $queryParams['envelope_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getEnvelopeIds());
            }
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getFromToStatus() != 'null') {
                $queryParams['from_to_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromToStatus());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getStatus() != 'null') {
                $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($options->getStatus());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
            if ($options->getTransactionIds() != 'null') {
                $queryParams['transaction_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getTransactionIds());
            }
            if ($options->getUserName() != 'null') {
                $queryParams['user_name'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserName());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_ids_request)) {
            $_tempBody = $envelope_ids_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopesInformation',
                '/v2.1/accounts/{accountId}/envelopes/status'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listStatusChanges
     *
     * Gets status changes for one or more envelopes.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListStatusChangesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopesInformation
     */
    public function listStatusChanges($account_id, \DocuSign\eSign\Api\EnvelopesApi\ListStatusChangesOptions $options = null)
    {
        list($response) = $this->listStatusChangesWithHttpInfo($account_id, $options);
        return $response;
    }

    /**
     * Operation listStatusChangesWithHttpInfo
     *
     * Gets status changes for one or more envelopes.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListStatusChangesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopesInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listStatusChangesWithHttpInfo($account_id, \DocuSign\eSign\Api\EnvelopesApi\ListStatusChangesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listStatusChanges');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAcStatus() != 'null') {
                $queryParams['ac_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getAcStatus());
            }
            if ($options->getBlock() != 'null') {
                $queryParams['block'] = $this->apiClient->getSerializer()->toQueryValue($options->getBlock());
            }
            if ($options->getCdseMode() != 'null') {
                $queryParams['cdse_mode'] = $this->apiClient->getSerializer()->toQueryValue($options->getCdseMode());
            }
            if ($options->getContinuationToken() != 'null') {
                $queryParams['continuation_token'] = $this->apiClient->getSerializer()->toQueryValue($options->getContinuationToken());
            }
            if ($options->getCount() != 'null') {
                $queryParams['count'] = $this->apiClient->getSerializer()->toQueryValue($options->getCount());
            }
            if ($options->getCustomField() != 'null') {
                $queryParams['custom_field'] = $this->apiClient->getSerializer()->toQueryValue($options->getCustomField());
            }
            if ($options->getEmail() != 'null') {
                $queryParams['email'] = $this->apiClient->getSerializer()->toQueryValue($options->getEmail());
            }
            if ($options->getEnvelopeIds() != 'null') {
                $queryParams['envelope_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getEnvelopeIds());
            }
            if ($options->getExclude() != 'null') {
                $queryParams['exclude'] = $this->apiClient->getSerializer()->toQueryValue($options->getExclude());
            }
            if ($options->getFolderIds() != 'null') {
                $queryParams['folder_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolderIds());
            }
            if ($options->getFolderTypes() != 'null') {
                $queryParams['folder_types'] = $this->apiClient->getSerializer()->toQueryValue($options->getFolderTypes());
            }
            if ($options->getFromDate() != 'null') {
                $queryParams['from_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromDate());
            }
            if ($options->getFromToStatus() != 'null') {
                $queryParams['from_to_status'] = $this->apiClient->getSerializer()->toQueryValue($options->getFromToStatus());
            }
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
            if ($options->getIncludePurgeInformation() != 'null') {
                $queryParams['include_purge_information'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludePurgeInformation());
            }
            if ($options->getIntersectingFolderIds() != 'null') {
                $queryParams['intersecting_folder_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getIntersectingFolderIds());
            }
            if ($options->getLastQueriedDate() != 'null') {
                $queryParams['last_queried_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getLastQueriedDate());
            }
            if ($options->getOrder() != 'null') {
                $queryParams['order'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrder());
            }
            if ($options->getOrderBy() != 'null') {
                $queryParams['order_by'] = $this->apiClient->getSerializer()->toQueryValue($options->getOrderBy());
            }
            if ($options->getPowerformids() != 'null') {
                $queryParams['powerformids'] = $this->apiClient->getSerializer()->toQueryValue($options->getPowerformids());
            }
            if ($options->getQueryBudget() != 'null') {
                $queryParams['query_budget'] = $this->apiClient->getSerializer()->toQueryValue($options->getQueryBudget());
            }
            if ($options->getRequesterDateFormat() != 'null') {
                $queryParams['requester_date_format'] = $this->apiClient->getSerializer()->toQueryValue($options->getRequesterDateFormat());
            }
            if ($options->getSearchMode() != 'null') {
                $queryParams['search_mode'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchMode());
            }
            if ($options->getSearchText() != 'null') {
                $queryParams['search_text'] = $this->apiClient->getSerializer()->toQueryValue($options->getSearchText());
            }
            if ($options->getStartPosition() != 'null') {
                $queryParams['start_position'] = $this->apiClient->getSerializer()->toQueryValue($options->getStartPosition());
            }
            if ($options->getStatus() != 'null') {
                $queryParams['status'] = $this->apiClient->getSerializer()->toQueryValue($options->getStatus());
            }
            if ($options->getToDate() != 'null') {
                $queryParams['to_date'] = $this->apiClient->getSerializer()->toQueryValue($options->getToDate());
            }
            if ($options->getTransactionIds() != 'null') {
                $queryParams['transaction_ids'] = $this->apiClient->getSerializer()->toQueryValue($options->getTransactionIds());
            }
            if ($options->getUserFilter() != 'null') {
                $queryParams['user_filter'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserFilter());
            }
            if ($options->getUserId() != 'null') {
                $queryParams['user_id'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserId());
            }
            if ($options->getUserName() != 'null') {
                $queryParams['user_name'] = $this->apiClient->getSerializer()->toQueryValue($options->getUserName());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopesInformation',
                '/v2.1/accounts/{accountId}/envelopes'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopesInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopesInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTabs
     *
     * Gets the tabs information for a signer or sign-in-person recipient in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListTabsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function listTabs($account_id, $envelope_id, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\ListTabsOptions $options = null)
    {
        list($response) = $this->listTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $options);
        return $response;
    }

    /**
     * Operation listTabsWithHttpInfo
     *
     * Gets the tabs information for a signer or sign-in-person recipient in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListTabsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, \DocuSign\eSign\Api\EnvelopesApi\ListTabsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling listTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getIncludeAnchorTabLocations() != 'null') {
                $queryParams['include_anchor_tab_locations'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeAnchorTabLocations());
            }
            if ($options->getIncludeMetadata() != 'null') {
                $queryParams['include_metadata'] = $this->apiClient->getSerializer()->toQueryValue($options->getIncludeMetadata());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTemplates
     *
     * Get List of Templates used in an Envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListTemplatesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateInformation
     */
    public function listTemplates($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\ListTemplatesOptions $options = null)
    {
        list($response) = $this->listTemplatesWithHttpInfo($account_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation listTemplatesWithHttpInfo
     *
     * Get List of Templates used in an Envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListTemplatesOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTemplatesWithHttpInfo($account_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\ListTemplatesOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTemplates');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listTemplates');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation listTemplatesForDocument
     *
     * Gets the templates associated with a document in an existing envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListTemplatesForDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateInformation
     */
    public function listTemplatesForDocument($account_id, $document_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\ListTemplatesForDocumentOptions $options = null)
    {
        list($response) = $this->listTemplatesForDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $options);
        return $response;
    }

    /**
     * Operation listTemplatesForDocumentWithHttpInfo
     *
     * Gets the templates associated with a document in an existing envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param  \DocuSign\eSign\Api\EnvelopesApi\ListTemplatesForDocumentOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTemplatesForDocumentWithHttpInfo($account_id, $document_id, $envelope_id, \DocuSign\eSign\Api\EnvelopesApi\ListTemplatesForDocumentOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling listTemplatesForDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling listTemplatesForDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling listTemplatesForDocument');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getInclude() != 'null') {
                $queryParams['include'] = $this->apiClient->getSerializer()->toQueryValue($options->getInclude());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/templates'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putAttachment
     *
     * Add an attachment to a DRAFT or IN-PROCESS envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $attachment_id 
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Attachment $attachment  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAttachmentsResult
     */
    public function putAttachment($account_id, $attachment_id, $envelope_id, $attachment = null)
    {
        list($response) = $this->putAttachmentWithHttpInfo($account_id, $attachment_id, $envelope_id, $attachment);
        return $response;
    }

    /**
     * Operation putAttachmentWithHttpInfo
     *
     * Add an attachment to a DRAFT or IN-PROCESS envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $attachment_id 
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Attachment $attachment  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAttachmentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function putAttachmentWithHttpInfo($account_id, $attachment_id, $envelope_id, $attachment = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling putAttachment');
        }
        // verify the required parameter 'attachment_id' is set
        if ($attachment_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $attachment_id when calling putAttachment');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling putAttachment');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($attachment_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "attachmentId", $attachment_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($attachment)) {
            $_tempBody = $attachment;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAttachmentsResult',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments/{attachmentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putAttachments
     *
     * Add one or more attachments to a DRAFT or IN-PROCESS envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeAttachmentsRequest $envelope_attachments_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeAttachmentsResult
     */
    public function putAttachments($account_id, $envelope_id, $envelope_attachments_request = null)
    {
        list($response) = $this->putAttachmentsWithHttpInfo($account_id, $envelope_id, $envelope_attachments_request);
        return $response;
    }

    /**
     * Operation putAttachmentsWithHttpInfo
     *
     * Add one or more attachments to a DRAFT or IN-PROCESS envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeAttachmentsRequest $envelope_attachments_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeAttachmentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function putAttachmentsWithHttpInfo($account_id, $envelope_id, $envelope_attachments_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling putAttachments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling putAttachments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_attachments_request)) {
            $_tempBody = $envelope_attachments_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeAttachmentsResult',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/attachments'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeAttachmentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation rotateDocumentPage
     *
     * Rotates page image from an envelope for display.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function rotateDocumentPage($account_id, $document_id, $envelope_id, $page_number, $page_request = null)
    {
        list($response) = $this->rotateDocumentPageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number, $page_request);
        return $response;
    }

    /**
     * Operation rotateDocumentPageWithHttpInfo
     *
     * Rotates page image from an envelope for display.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $page_number The page number being accessed.
     * @param \DocuSign\eSign\Model\PageRequest $page_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function rotateDocumentPageWithHttpInfo($account_id, $document_id, $envelope_id, $page_number, $page_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling rotateDocumentPage');
        }
        // verify the required parameter 'page_number' is set
        if ($page_number === null) {
            throw new \InvalidArgumentException('Missing the required parameter $page_number when calling rotateDocumentPage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($page_number !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "pageNumber", $page_number);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($page_request)) {
            $_tempBody = $page_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/pages/{pageNumber}/page_image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation update
     *
     * Send Draft Envelope/Void Envelope/Move/Purge Envelope/Modify draft
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Envelope $envelope  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\UpdateOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeUpdateSummary
     */
    public function update($account_id, $envelope_id, $envelope = null, \DocuSign\eSign\Api\EnvelopesApi\UpdateOptions $options = null)
    {
        list($response) = $this->updateWithHttpInfo($account_id, $envelope_id, $envelope, $options);
        return $response;
    }

    /**
     * Operation updateWithHttpInfo
     *
     * Send Draft Envelope/Void Envelope/Move/Purge Envelope/Modify draft
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Envelope $envelope  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\UpdateOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeUpdateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateWithHttpInfo($account_id, $envelope_id, $envelope = null, \DocuSign\eSign\Api\EnvelopesApi\UpdateOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling update');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling update');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAdvancedUpdate() != 'null') {
                $queryParams['advanced_update'] = $this->apiClient->getSerializer()->toQueryValue($options->getAdvancedUpdate());
            }
            if ($options->getResendEnvelope() != 'null') {
                $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope)) {
            $_tempBody = $envelope;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeUpdateSummary',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeUpdateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeUpdateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateChunkedUpload
     *
     * Integrity-Check and Commit a ChunkedUpload, readying it for use elsewhere.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $chunked_upload_id 
     * @param  \DocuSign\eSign\Api\EnvelopesApi\UpdateChunkedUploadOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function updateChunkedUpload($account_id, $chunked_upload_id, \DocuSign\eSign\Api\EnvelopesApi\UpdateChunkedUploadOptions $options = null)
    {
        list($response) = $this->updateChunkedUploadWithHttpInfo($account_id, $chunked_upload_id, $options);
        return $response;
    }

    /**
     * Operation updateChunkedUploadWithHttpInfo
     *
     * Integrity-Check and Commit a ChunkedUpload, readying it for use elsewhere.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $chunked_upload_id 
     * @param  \DocuSign\eSign\Api\EnvelopesApi\UpdateChunkedUploadOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateChunkedUploadWithHttpInfo($account_id, $chunked_upload_id, \DocuSign\eSign\Api\EnvelopesApi\UpdateChunkedUploadOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateChunkedUpload');
        }
        // verify the required parameter 'chunked_upload_id' is set
        if ($chunked_upload_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_id when calling updateChunkedUpload');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getAction() != 'null') {
                $queryParams['action'] = $this->apiClient->getSerializer()->toQueryValue($options->getAction());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($chunked_upload_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "chunkedUploadId", $chunked_upload_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateChunkedUploadPart
     *
     * Add a chunk, a chunk 'part', to an existing ChunkedUpload.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $chunked_upload_id 
     * @param ?string $chunked_upload_part_seq 
     * @param \DocuSign\eSign\Model\ChunkedUploadRequest $chunked_upload_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ChunkedUploadResponse
     */
    public function updateChunkedUploadPart($account_id, $chunked_upload_id, $chunked_upload_part_seq, $chunked_upload_request = null)
    {
        list($response) = $this->updateChunkedUploadPartWithHttpInfo($account_id, $chunked_upload_id, $chunked_upload_part_seq, $chunked_upload_request);
        return $response;
    }

    /**
     * Operation updateChunkedUploadPartWithHttpInfo
     *
     * Add a chunk, a chunk 'part', to an existing ChunkedUpload.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $chunked_upload_id 
     * @param ?string $chunked_upload_part_seq 
     * @param \DocuSign\eSign\Model\ChunkedUploadRequest $chunked_upload_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ChunkedUploadResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateChunkedUploadPartWithHttpInfo($account_id, $chunked_upload_id, $chunked_upload_part_seq, $chunked_upload_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateChunkedUploadPart');
        }
        // verify the required parameter 'chunked_upload_id' is set
        if ($chunked_upload_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_id when calling updateChunkedUploadPart');
        }
        // verify the required parameter 'chunked_upload_part_seq' is set
        if ($chunked_upload_part_seq === null) {
            throw new \InvalidArgumentException('Missing the required parameter $chunked_upload_part_seq when calling updateChunkedUploadPart');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/{chunkedUploadPartSeq}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($chunked_upload_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "chunkedUploadId", $chunked_upload_id);
        }
        // path params
        if ($chunked_upload_part_seq !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "chunkedUploadPartSeq", $chunked_upload_part_seq);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($chunked_upload_request)) {
            $_tempBody = $chunked_upload_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ChunkedUploadResponse',
                '/v2.1/accounts/{accountId}/chunked_uploads/{chunkedUploadId}/{chunkedUploadPartSeq}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ChunkedUploadResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ChunkedUploadResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateCustomFields
     *
     * Updates envelope custom fields in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\CustomFields
     */
    public function updateCustomFields($account_id, $envelope_id, $custom_fields = null)
    {
        list($response) = $this->updateCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields);
        return $response;
    }

    /**
     * Operation updateCustomFieldsWithHttpInfo
     *
     * Updates envelope custom fields in an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\CustomFields $custom_fields  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\CustomFields, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCustomFieldsWithHttpInfo($account_id, $envelope_id, $custom_fields = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateCustomFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateCustomFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($custom_fields)) {
            $_tempBody = $custom_fields;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\CustomFields',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/custom_fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\CustomFields', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\CustomFields', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocument
     *
     * Adds a document to an existing draft envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $document_file_bytes Updated document content. (required)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeDocument
     */
    public function updateDocument($account_id, $document_id, $envelope_id, $document_file_bytes)
    {
        list($response) = $this->updateDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $document_file_bytes);
        return $response;
    }

    /**
     * Operation updateDocumentWithHttpInfo
     *
     * Adds a document to an existing draft envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $document_file_bytes Updated document content. (required)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeDocument, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentWithHttpInfo($account_id, $document_id, $envelope_id, $document_file_bytes): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocument');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateDocument');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateDocument');
        }
        // verify the required parameter 'document_file_bytes' is set
        if ($document_file_bytes === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_file_bytes when calling updateDocument');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['application/pdf']);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_file_bytes)) {
            $_tempBody = $document_file_bytes;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeDocument',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeDocument', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeDocument', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocumentFields
     *
     * Updates existing custom document fields in an existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentFieldsInformation
     */
    public function updateDocumentFields($account_id, $document_id, $envelope_id, $document_fields_information = null)
    {
        list($response) = $this->updateDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information);
        return $response;
    }

    /**
     * Operation updateDocumentFieldsWithHttpInfo
     *
     * Updates existing custom document fields in an existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentFieldsInformation $document_fields_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentFieldsInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentFieldsWithHttpInfo($account_id, $document_id, $envelope_id, $document_fields_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocumentFields');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateDocumentFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateDocumentFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_fields_information)) {
            $_tempBody = $document_fields_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentFieldsInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/fields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentFieldsInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentFieldsInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocumentTabs
     *
     * Updates the tabs for an envelope document
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function updateDocumentTabs($account_id, $document_id, $envelope_id, $tabs = null)
    {
        list($response) = $this->updateDocumentTabsWithHttpInfo($account_id, $document_id, $envelope_id, $tabs);
        return $response;
    }

    /**
     * Operation updateDocumentTabsWithHttpInfo
     *
     * Updates the tabs for an envelope document
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $document_id The ID of the document being accessed.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentTabsWithHttpInfo($account_id, $document_id, $envelope_id, $tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocumentTabs');
        }
        // verify the required parameter 'document_id' is set
        if ($document_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $document_id when calling updateDocumentTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateDocumentTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($document_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "documentId", $document_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($tabs)) {
            $_tempBody = $tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents/{documentId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateDocuments
     *
     * Adds one or more documents to an existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeDocumentsResult
     */
    public function updateDocuments($account_id, $envelope_id, $envelope_definition = null)
    {
        list($response) = $this->updateDocumentsWithHttpInfo($account_id, $envelope_id, $envelope_definition);
        return $response;
    }

    /**
     * Operation updateDocumentsWithHttpInfo
     *
     * Adds one or more documents to an existing envelope document.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeDefinition $envelope_definition  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeDocumentsResult, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateDocumentsWithHttpInfo($account_id, $envelope_id, $envelope_definition = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateDocuments');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateDocuments');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_definition)) {
            $_tempBody = $envelope_definition;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeDocumentsResult',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/documents'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeDocumentsResult', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEmailSettings
     *
     * Updates the email setting overrides for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EmailSettings
     */
    public function updateEmailSettings($account_id, $envelope_id, $email_settings = null)
    {
        list($response) = $this->updateEmailSettingsWithHttpInfo($account_id, $envelope_id, $email_settings);
        return $response;
    }

    /**
     * Operation updateEmailSettingsWithHttpInfo
     *
     * Updates the email setting overrides for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EmailSettings $email_settings  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EmailSettings, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmailSettingsWithHttpInfo($account_id, $envelope_id, $email_settings = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEmailSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateEmailSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($email_settings)) {
            $_tempBody = $email_settings;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EmailSettings',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/email_settings'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EmailSettings', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EmailSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEnvelopeDelayedRoutingDefinition
     *
     * Updates the delayed routing rules for an envelope's workflow step definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     * @param \DocuSign\eSign\Model\DelayedRouting $delayed_routing  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DelayedRouting
     */
    public function updateEnvelopeDelayedRoutingDefinition($account_id, $envelope_id, $workflow_step_id, $delayed_routing = null)
    {
        list($response) = $this->updateEnvelopeDelayedRoutingDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id, $delayed_routing);
        return $response;
    }

    /**
     * Operation updateEnvelopeDelayedRoutingDefinitionWithHttpInfo
     *
     * Updates the delayed routing rules for an envelope's workflow step definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     * @param \DocuSign\eSign\Model\DelayedRouting $delayed_routing  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DelayedRouting, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEnvelopeDelayedRoutingDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id, $delayed_routing = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEnvelopeDelayedRoutingDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateEnvelopeDelayedRoutingDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling updateEnvelopeDelayedRoutingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($delayed_routing)) {
            $_tempBody = $delayed_routing;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DelayedRouting',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}/delayedRouting'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DelayedRouting', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DelayedRouting', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEnvelopeDocGenFormFields
     *
     * Updates formfields for an envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocGenFormFieldRequest $doc_gen_form_field_request  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\UpdateEnvelopeDocGenFormFieldsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocGenFormFieldResponse
     */
    public function updateEnvelopeDocGenFormFields($account_id, $envelope_id, $doc_gen_form_field_request = null, \DocuSign\eSign\Api\EnvelopesApi\UpdateEnvelopeDocGenFormFieldsOptions $options = null)
    {
        list($response) = $this->updateEnvelopeDocGenFormFieldsWithHttpInfo($account_id, $envelope_id, $doc_gen_form_field_request, $options);
        return $response;
    }

    /**
     * Operation updateEnvelopeDocGenFormFieldsWithHttpInfo
     *
     * Updates formfields for an envelope
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocGenFormFieldRequest $doc_gen_form_field_request  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\UpdateEnvelopeDocGenFormFieldsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocGenFormFieldResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEnvelopeDocGenFormFieldsWithHttpInfo($account_id, $envelope_id, $doc_gen_form_field_request = null, \DocuSign\eSign\Api\EnvelopesApi\UpdateEnvelopeDocGenFormFieldsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEnvelopeDocGenFormFields');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateEnvelopeDocGenFormFields');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/docGenFormFields";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getUpdateDocgenFormfieldsOnly() != 'null') {
                $queryParams['update_docgen_formfields_only'] = $this->apiClient->getSerializer()->toQueryValue($options->getUpdateDocgenFormfieldsOnly());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($doc_gen_form_field_request)) {
            $_tempBody = $doc_gen_form_field_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocGenFormFieldResponse',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/docGenFormFields'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocGenFormFieldResponse', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocGenFormFieldResponse', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEnvelopeScheduledSendingDefinition
     *
     * Updates the scheduled sending rules for an envelope's workflow definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ScheduledSending $scheduled_sending  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ScheduledSending
     */
    public function updateEnvelopeScheduledSendingDefinition($account_id, $envelope_id, $scheduled_sending = null)
    {
        list($response) = $this->updateEnvelopeScheduledSendingDefinitionWithHttpInfo($account_id, $envelope_id, $scheduled_sending);
        return $response;
    }

    /**
     * Operation updateEnvelopeScheduledSendingDefinitionWithHttpInfo
     *
     * Updates the scheduled sending rules for an envelope's workflow definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\ScheduledSending $scheduled_sending  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ScheduledSending, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEnvelopeScheduledSendingDefinitionWithHttpInfo($account_id, $envelope_id, $scheduled_sending = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEnvelopeScheduledSendingDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateEnvelopeScheduledSendingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($scheduled_sending)) {
            $_tempBody = $scheduled_sending;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ScheduledSending',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/scheduledSending'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ScheduledSending', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ScheduledSending', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEnvelopeTransferRule
     *
     * Update an envelope transfer rule for an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_transfer_rule_id 
     * @param \DocuSign\eSign\Model\EnvelopeTransferRule $envelope_transfer_rule  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeTransferRule
     */
    public function updateEnvelopeTransferRule($account_id, $envelope_transfer_rule_id, $envelope_transfer_rule = null)
    {
        list($response) = $this->updateEnvelopeTransferRuleWithHttpInfo($account_id, $envelope_transfer_rule_id, $envelope_transfer_rule);
        return $response;
    }

    /**
     * Operation updateEnvelopeTransferRuleWithHttpInfo
     *
     * Update an envelope transfer rule for an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_transfer_rule_id 
     * @param \DocuSign\eSign\Model\EnvelopeTransferRule $envelope_transfer_rule  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeTransferRule, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEnvelopeTransferRuleWithHttpInfo($account_id, $envelope_transfer_rule_id, $envelope_transfer_rule = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEnvelopeTransferRule');
        }
        // verify the required parameter 'envelope_transfer_rule_id' is set
        if ($envelope_transfer_rule_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_transfer_rule_id when calling updateEnvelopeTransferRule');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_transfer_rule_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeTransferRuleId", $envelope_transfer_rule_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_transfer_rule)) {
            $_tempBody = $envelope_transfer_rule;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeTransferRule',
                '/v2.1/accounts/{accountId}/envelopes/transfer_rules/{envelopeTransferRuleId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeTransferRule', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeTransferRule', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEnvelopeTransferRules
     *
     * Update envelope transfer rules for an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeTransferRuleInformation $envelope_transfer_rule_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\EnvelopeTransferRuleInformation
     */
    public function updateEnvelopeTransferRules($account_id, $envelope_transfer_rule_information = null)
    {
        list($response) = $this->updateEnvelopeTransferRulesWithHttpInfo($account_id, $envelope_transfer_rule_information);
        return $response;
    }

    /**
     * Operation updateEnvelopeTransferRulesWithHttpInfo
     *
     * Update envelope transfer rules for an account.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param \DocuSign\eSign\Model\EnvelopeTransferRuleInformation $envelope_transfer_rule_information  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\EnvelopeTransferRuleInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEnvelopeTransferRulesWithHttpInfo($account_id, $envelope_transfer_rule_information = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEnvelopeTransferRules');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/transfer_rules";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_transfer_rule_information)) {
            $_tempBody = $envelope_transfer_rule_information;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\EnvelopeTransferRuleInformation',
                '/v2.1/accounts/{accountId}/envelopes/transfer_rules'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\EnvelopeTransferRuleInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\EnvelopeTransferRuleInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEnvelopeWorkflowDefinition
     *
     * Updates the envelope workflow definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Workflow $workflow  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workflow
     */
    public function updateEnvelopeWorkflowDefinition($account_id, $envelope_id, $workflow = null)
    {
        list($response) = $this->updateEnvelopeWorkflowDefinitionWithHttpInfo($account_id, $envelope_id, $workflow);
        return $response;
    }

    /**
     * Operation updateEnvelopeWorkflowDefinitionWithHttpInfo
     *
     * Updates the envelope workflow definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Workflow $workflow  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workflow, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEnvelopeWorkflowDefinitionWithHttpInfo($account_id, $envelope_id, $workflow = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEnvelopeWorkflowDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateEnvelopeWorkflowDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($workflow)) {
            $_tempBody = $workflow;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workflow',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workflow', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workflow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateEnvelopeWorkflowStepDefinition
     *
     * Updates the envelope workflow step definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     * @param \DocuSign\eSign\Model\WorkflowStep $workflow_step  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkflowStep
     */
    public function updateEnvelopeWorkflowStepDefinition($account_id, $envelope_id, $workflow_step_id, $workflow_step = null)
    {
        list($response) = $this->updateEnvelopeWorkflowStepDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id, $workflow_step);
        return $response;
    }

    /**
     * Operation updateEnvelopeWorkflowStepDefinitionWithHttpInfo
     *
     * Updates the envelope workflow step definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $workflow_step_id 
     * @param \DocuSign\eSign\Model\WorkflowStep $workflow_step  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkflowStep, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEnvelopeWorkflowStepDefinitionWithHttpInfo($account_id, $envelope_id, $workflow_step_id, $workflow_step = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateEnvelopeWorkflowStepDefinition');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateEnvelopeWorkflowStepDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling updateEnvelopeWorkflowStepDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($workflow_step)) {
            $_tempBody = $workflow_step;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkflowStep',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/workflow/steps/{workflowStepId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkflowStep', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkflowStep', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateLock
     *
     * Updates an envelope lock.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\LockInformation
     */
    public function updateLock($account_id, $envelope_id, $lock_request = null)
    {
        list($response) = $this->updateLockWithHttpInfo($account_id, $envelope_id, $lock_request);
        return $response;
    }

    /**
     * Operation updateLockWithHttpInfo
     *
     * Updates an envelope lock.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\LockRequest $lock_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\LockInformation, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLockWithHttpInfo($account_id, $envelope_id, $lock_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateLock');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateLock');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($lock_request)) {
            $_tempBody = $lock_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\LockInformation',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/lock'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\LockInformation', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\LockInformation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateNotificationSettings
     *
     * Sets envelope notification (Reminders/Expirations) structure for an existing envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeNotificationRequest $envelope_notification_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Notification
     */
    public function updateNotificationSettings($account_id, $envelope_id, $envelope_notification_request = null)
    {
        list($response) = $this->updateNotificationSettingsWithHttpInfo($account_id, $envelope_id, $envelope_notification_request);
        return $response;
    }

    /**
     * Operation updateNotificationSettingsWithHttpInfo
     *
     * Sets envelope notification (Reminders/Expirations) structure for an existing envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\EnvelopeNotificationRequest $envelope_notification_request  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Notification, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateNotificationSettingsWithHttpInfo($account_id, $envelope_id, $envelope_notification_request = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateNotificationSettings');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateNotificationSettings');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($envelope_notification_request)) {
            $_tempBody = $envelope_notification_request;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Notification',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/notification'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Notification', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Notification', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipientDocumentVisibility
     *
     * Updates document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\DocumentVisibilityList $document_visibility_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentVisibilityList
     */
    public function updateRecipientDocumentVisibility($account_id, $envelope_id, $recipient_id, $document_visibility_list = null)
    {
        list($response) = $this->updateRecipientDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $recipient_id, $document_visibility_list);
        return $response;
    }

    /**
     * Operation updateRecipientDocumentVisibilityWithHttpInfo
     *
     * Updates document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\DocumentVisibilityList $document_visibility_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $recipient_id, $document_visibility_list = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipientDocumentVisibility');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipientDocumentVisibility');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateRecipientDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_visibility_list)) {
            $_tempBody = $document_visibility_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentVisibilityList',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipientInitialsImage
     *
     * Sets the initials image for an accountless signer.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function updateRecipientInitialsImage($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->updateRecipientInitialsImageWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation updateRecipientInitialsImageWithHttpInfo
     *
     * Sets the initials image for an accountless signer.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientInitialsImageWithHttpInfo($account_id, $envelope_id, $recipient_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipientInitialsImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipientInitialsImage');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateRecipientInitialsImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['image/gif']);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/initials_image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipientSignatureImage
     *
     * Sets the signature image for an accountless signer.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function updateRecipientSignatureImage($account_id, $envelope_id, $recipient_id)
    {
        list($response) = $this->updateRecipientSignatureImageWithHttpInfo($account_id, $envelope_id, $recipient_id);
        return $response;
    }

    /**
     * Operation updateRecipientSignatureImageWithHttpInfo
     *
     * Sets the signature image for an accountless signer.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientSignatureImageWithHttpInfo($account_id, $envelope_id, $recipient_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipientSignatureImage');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipientSignatureImage');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateRecipientSignatureImage');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(['image/gif']);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/signature_image'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipients
     *
     * Updates recipients in a draft envelope or corrects recipient information for an in process envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\UpdateRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\RecipientsUpdateSummary
     */
    public function updateRecipients($account_id, $envelope_id, $recipients = null, \DocuSign\eSign\Api\EnvelopesApi\UpdateRecipientsOptions $options = null)
    {
        list($response) = $this->updateRecipientsWithHttpInfo($account_id, $envelope_id, $recipients, $options);
        return $response;
    }

    /**
     * Operation updateRecipientsWithHttpInfo
     *
     * Updates recipients in a draft envelope or corrects recipient information for an in process envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\Recipients $recipients  (optional)
     * @param  \DocuSign\eSign\Api\EnvelopesApi\UpdateRecipientsOptions  $options for modifying the behavior of the function. (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\RecipientsUpdateSummary, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientsWithHttpInfo($account_id, $envelope_id, $recipients = null, \DocuSign\eSign\Api\EnvelopesApi\UpdateRecipientsOptions $options = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipients');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipients');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);

        if ($options != null)
        {
            // query params
            if ($options->getCombineSameOrderRecipients() != 'null') {
                $queryParams['combine_same_order_recipients'] = $this->apiClient->getSerializer()->toQueryValue($options->getCombineSameOrderRecipients());
            }
            if ($options->getOfflineSigning() != 'null') {
                $queryParams['offline_signing'] = $this->apiClient->getSerializer()->toQueryValue($options->getOfflineSigning());
            }
            if ($options->getResendEnvelope() != 'null') {
                $queryParams['resend_envelope'] = $this->apiClient->getSerializer()->toQueryValue($options->getResendEnvelope());
            }
        }

        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($recipients)) {
            $_tempBody = $recipients;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\RecipientsUpdateSummary',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\RecipientsUpdateSummary', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\RecipientsUpdateSummary', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateRecipientsDocumentVisibility
     *
     * Updates document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentVisibilityList $document_visibility_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DocumentVisibilityList
     */
    public function updateRecipientsDocumentVisibility($account_id, $envelope_id, $document_visibility_list = null)
    {
        list($response) = $this->updateRecipientsDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $document_visibility_list);
        return $response;
    }

    /**
     * Operation updateRecipientsDocumentVisibilityWithHttpInfo
     *
     * Updates document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param \DocuSign\eSign\Model\DocumentVisibilityList $document_visibility_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRecipientsDocumentVisibilityWithHttpInfo($account_id, $envelope_id, $document_visibility_list = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateRecipientsDocumentVisibility');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateRecipientsDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/document_visibility";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($document_visibility_list)) {
            $_tempBody = $document_visibility_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DocumentVisibilityList',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTabs
     *
     * Updates the tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Tabs
     */
    public function updateTabs($account_id, $envelope_id, $recipient_id, $tabs = null)
    {
        list($response) = $this->updateTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs);
        return $response;
    }

    /**
     * Operation updateTabsWithHttpInfo
     *
     * Updates the tabs for a recipient.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param \DocuSign\eSign\Model\Tabs $tabs  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Tabs, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTabsWithHttpInfo($account_id, $envelope_id, $recipient_id, $tabs = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTabs');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateTabs');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateTabs');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($tabs)) {
            $_tempBody = $tabs;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Tabs',
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/recipients/{recipientId}/tabs'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Tabs', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Tabs', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTabsBlob
     *
     * Update encrypted tabs for envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return mixed
     */
    public function updateTabsBlob($account_id, $envelope_id)
    {
        list($response) = $this->updateTabsBlobWithHttpInfo($account_id, $envelope_id);
        return $response;
    }

    /**
     * Operation updateTabsBlobWithHttpInfo
     *
     * Update encrypted tabs for envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $envelope_id The envelopeId Guid of the envelope being accessed.
     *
     * @throws ApiException on non-2xx response
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTabsBlobWithHttpInfo($account_id, $envelope_id): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTabsBlob');
        }
        // verify the required parameter 'envelope_id' is set
        if ($envelope_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $envelope_id when calling updateTabsBlob');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($envelope_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "envelopeId", $envelope_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/v2.1/accounts/{accountId}/envelopes/{envelopeId}/tabs_blob'
            );

            return [null, $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTemplateDelayedRoutingDefinition
     *
     * Updates the delayed routing rules for a template's workflow step definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     * @param \DocuSign\eSign\Model\DelayedRouting $delayed_routing  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\DelayedRouting
     */
    public function updateTemplateDelayedRoutingDefinition($account_id, $template_id, $workflow_step_id, $delayed_routing = null)
    {
        list($response) = $this->updateTemplateDelayedRoutingDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id, $delayed_routing);
        return $response;
    }

    /**
     * Operation updateTemplateDelayedRoutingDefinitionWithHttpInfo
     *
     * Updates the delayed routing rules for a template's workflow step definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     * @param \DocuSign\eSign\Model\DelayedRouting $delayed_routing  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\DelayedRouting, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTemplateDelayedRoutingDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id, $delayed_routing = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTemplateDelayedRoutingDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTemplateDelayedRoutingDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling updateTemplateDelayedRoutingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($delayed_routing)) {
            $_tempBody = $delayed_routing;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\DelayedRouting',
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}/delayedRouting'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\DelayedRouting', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\DelayedRouting', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTemplateRecipientDocumentVisibility
     *
     * Updates document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateDocumentVisibilityList $template_document_visibility_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentVisibilityList
     */
    public function updateTemplateRecipientDocumentVisibility($account_id, $recipient_id, $template_id, $template_document_visibility_list = null)
    {
        list($response) = $this->updateTemplateRecipientDocumentVisibilityWithHttpInfo($account_id, $recipient_id, $template_id, $template_document_visibility_list);
        return $response;
    }

    /**
     * Operation updateTemplateRecipientDocumentVisibilityWithHttpInfo
     *
     * Updates document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $recipient_id The ID of the recipient being accessed.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateDocumentVisibilityList $template_document_visibility_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTemplateRecipientDocumentVisibilityWithHttpInfo($account_id, $recipient_id, $template_id, $template_document_visibility_list = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTemplateRecipientDocumentVisibility');
        }
        // verify the required parameter 'recipient_id' is set
        if ($recipient_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $recipient_id when calling updateTemplateRecipientDocumentVisibility');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTemplateRecipientDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($recipient_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "recipientId", $recipient_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_document_visibility_list)) {
            $_tempBody = $template_document_visibility_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentVisibilityList',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/{recipientId}/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTemplateRecipientsDocumentVisibility
     *
     * Updates document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateDocumentVisibilityList $template_document_visibility_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\TemplateDocumentVisibilityList
     */
    public function updateTemplateRecipientsDocumentVisibility($account_id, $template_id, $template_document_visibility_list = null)
    {
        list($response) = $this->updateTemplateRecipientsDocumentVisibilityWithHttpInfo($account_id, $template_id, $template_document_visibility_list);
        return $response;
    }

    /**
     * Operation updateTemplateRecipientsDocumentVisibilityWithHttpInfo
     *
     * Updates document visibility for the recipients
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\TemplateDocumentVisibilityList $template_document_visibility_list  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\TemplateDocumentVisibilityList, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTemplateRecipientsDocumentVisibilityWithHttpInfo($account_id, $template_id, $template_document_visibility_list = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTemplateRecipientsDocumentVisibility');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTemplateRecipientsDocumentVisibility');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/recipients/document_visibility";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($template_document_visibility_list)) {
            $_tempBody = $template_document_visibility_list;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\TemplateDocumentVisibilityList',
                '/v2.1/accounts/{accountId}/templates/{templateId}/recipients/document_visibility'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\TemplateDocumentVisibilityList', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\TemplateDocumentVisibilityList', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTemplateScheduledSendingDefinition
     *
     * Updates the scheduled sending rules for a template's workflow definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\ScheduledSending $scheduled_sending  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\ScheduledSending
     */
    public function updateTemplateScheduledSendingDefinition($account_id, $template_id, $scheduled_sending = null)
    {
        list($response) = $this->updateTemplateScheduledSendingDefinitionWithHttpInfo($account_id, $template_id, $scheduled_sending);
        return $response;
    }

    /**
     * Operation updateTemplateScheduledSendingDefinitionWithHttpInfo
     *
     * Updates the scheduled sending rules for a template's workflow definition.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\ScheduledSending $scheduled_sending  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\ScheduledSending, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTemplateScheduledSendingDefinitionWithHttpInfo($account_id, $template_id, $scheduled_sending = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTemplateScheduledSendingDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTemplateScheduledSendingDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($scheduled_sending)) {
            $_tempBody = $scheduled_sending;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\ScheduledSending',
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/scheduledSending'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\ScheduledSending', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ScheduledSending', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTemplateWorkflowDefinition
     *
     * Updates the workflow definition for a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\Workflow $workflow  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\Workflow
     */
    public function updateTemplateWorkflowDefinition($account_id, $template_id, $workflow = null)
    {
        list($response) = $this->updateTemplateWorkflowDefinitionWithHttpInfo($account_id, $template_id, $workflow);
        return $response;
    }

    /**
     * Operation updateTemplateWorkflowDefinitionWithHttpInfo
     *
     * Updates the workflow definition for a template.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param \DocuSign\eSign\Model\Workflow $workflow  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\Workflow, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTemplateWorkflowDefinitionWithHttpInfo($account_id, $template_id, $workflow = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTemplateWorkflowDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTemplateWorkflowDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($workflow)) {
            $_tempBody = $workflow;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\Workflow',
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\Workflow', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\Workflow', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation updateTemplateWorkflowStepDefinition
     *
     * Updates the template workflow step definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     * @param \DocuSign\eSign\Model\WorkflowStep $workflow_step  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return \DocuSign\eSign\Model\WorkflowStep
     */
    public function updateTemplateWorkflowStepDefinition($account_id, $template_id, $workflow_step_id, $workflow_step = null)
    {
        list($response) = $this->updateTemplateWorkflowStepDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id, $workflow_step);
        return $response;
    }

    /**
     * Operation updateTemplateWorkflowStepDefinitionWithHttpInfo
     *
     * Updates the template workflow step definition for an envelope.
     *
     * @param ?string $account_id The external account number (int) or account ID Guid.
     * @param ?string $template_id The ID of the template being accessed.
     * @param ?string $workflow_step_id 
     * @param \DocuSign\eSign\Model\WorkflowStep $workflow_step  (optional)
     *
     * @throws ApiException on non-2xx response
     * @return array of \DocuSign\eSign\Model\WorkflowStep, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTemplateWorkflowStepDefinitionWithHttpInfo($account_id, $template_id, $workflow_step_id, $workflow_step = null): array
    {
        // verify the required parameter 'account_id' is set
        if ($account_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $account_id when calling updateTemplateWorkflowStepDefinition');
        }
        // verify the required parameter 'template_id' is set
        if ($template_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $template_id when calling updateTemplateWorkflowStepDefinition');
        }
        // verify the required parameter 'workflow_step_id' is set
        if ($workflow_step_id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $workflow_step_id when calling updateTemplateWorkflowStepDefinition');
        }
        // parse inputs
        $resourcePath = "/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}";
        $httpBody = $_tempBody ?? ''; // $_tempBody is the method argument, if present
        $queryParams = $headerParams = $formParams = [];
        $headerParams['Accept'] ??= $this->apiClient->selectHeaderAccept(['application/json']);
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType([]);


        // path params
        if ($account_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "accountId", $account_id);
        }
        // path params
        if ($template_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "templateId", $template_id);
        }
        // path params
        if ($workflow_step_id !== null) {
            $resourcePath = self::updateResourcePath($resourcePath, "workflowStepId", $workflow_step_id);
        }

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);
        // body params
        $_tempBody = null;
        if (isset($workflow_step)) {
            $_tempBody = $workflow_step;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\DocuSign\eSign\Model\WorkflowStep',
                '/v2.1/accounts/{accountId}/templates/{templateId}/workflow/steps/{workflowStepId}'
            );

            return [$this->apiClient->getSerializer()->deserialize($response, '\DocuSign\eSign\Model\WorkflowStep', $httpHeader), $statusCode, $httpHeader];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\WorkflowStep', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\DocuSign\eSign\Model\ErrorDetails', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }
}
